// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannelRequest
type GetApnsSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsSandboxChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetApnsSandboxChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApnsSandboxChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannelResponse
type GetApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Apple Development Push Notification Service channel definition.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApnsSandboxChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.APNSSandboxChannelResponse != nil {
		v := s.APNSSandboxChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "APNSSandboxChannelResponse", v, metadata)
	}
	return nil
}

const opGetApnsSandboxChannel = "GetApnsSandboxChannel"

// GetApnsSandboxChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Get an APNS sandbox channel.
//
//    // Example sending a request using GetApnsSandboxChannelRequest.
//    req := client.GetApnsSandboxChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel
func (c *Client) GetApnsSandboxChannelRequest(input *GetApnsSandboxChannelInput) GetApnsSandboxChannelRequest {
	op := &aws.Operation{
		Name:       opGetApnsSandboxChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &GetApnsSandboxChannelInput{}
	}

	req := c.newRequest(op, input, &GetApnsSandboxChannelOutput{})
	return GetApnsSandboxChannelRequest{Request: req, Input: input, Copy: c.GetApnsSandboxChannelRequest}
}

// GetApnsSandboxChannelRequest is the request type for the
// GetApnsSandboxChannel API operation.
type GetApnsSandboxChannelRequest struct {
	*aws.Request
	Input *GetApnsSandboxChannelInput
	Copy  func(*GetApnsSandboxChannelInput) GetApnsSandboxChannelRequest
}

// Send marshals and sends the GetApnsSandboxChannel API request.
func (r GetApnsSandboxChannelRequest) Send(ctx context.Context) (*GetApnsSandboxChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetApnsSandboxChannelResponse{
		GetApnsSandboxChannelOutput: r.Request.Data.(*GetApnsSandboxChannelOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetApnsSandboxChannelResponse is the response type for the
// GetApnsSandboxChannel API operation.
type GetApnsSandboxChannelResponse struct {
	*GetApnsSandboxChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetApnsSandboxChannel request.
func (r *GetApnsSandboxChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
