// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroupstaggingapi

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagKeysInput
type GetTagKeysInput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`
}

// String returns the string representation
func (s GetTagKeysInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagKeysOutput
type GetTagKeysOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A list of all tag keys in the AWS account.
	TagKeys []string `type:"list"`
}

// String returns the string representation
func (s GetTagKeysOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTagKeys = "GetTagKeys"

// GetTagKeysRequest returns a request value for making API operation for
// AWS Resource Groups Tagging API.
//
// Returns all tag keys in the specified region for the AWS account.
//
//    // Example sending a request using GetTagKeysRequest.
//    req := client.GetTagKeysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagKeys
func (c *Client) GetTagKeysRequest(input *GetTagKeysInput) GetTagKeysRequest {
	op := &aws.Operation{
		Name:       opGetTagKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTagKeysInput{}
	}

	req := c.newRequest(op, input, &GetTagKeysOutput{})
	return GetTagKeysRequest{Request: req, Input: input, Copy: c.GetTagKeysRequest}
}

// GetTagKeysRequest is the request type for the
// GetTagKeys API operation.
type GetTagKeysRequest struct {
	*aws.Request
	Input *GetTagKeysInput
	Copy  func(*GetTagKeysInput) GetTagKeysRequest
}

// Send marshals and sends the GetTagKeys API request.
func (r GetTagKeysRequest) Send(ctx context.Context) (*GetTagKeysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTagKeysResponse{
		GetTagKeysOutput: r.Request.Data.(*GetTagKeysOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetTagKeysRequestPaginator returns a paginator for GetTagKeys.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetTagKeysRequest(input)
//   p := resourcegroupstaggingapi.NewGetTagKeysRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetTagKeysPaginator(req GetTagKeysRequest) GetTagKeysPaginator {
	return GetTagKeysPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetTagKeysInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetTagKeysPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetTagKeysPaginator struct {
	aws.Pager
}

func (p *GetTagKeysPaginator) CurrentPage() *GetTagKeysOutput {
	return p.Pager.CurrentPage().(*GetTagKeysOutput)
}

// GetTagKeysResponse is the response type for the
// GetTagKeys API operation.
type GetTagKeysResponse struct {
	*GetTagKeysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTagKeys request.
func (r *GetTagKeysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
