// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package robomaker

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about a deployment application configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeploymentApplicationConfig
type DeploymentApplicationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string" required:"true"`

	// The launch configuration.
	//
	// LaunchConfig is a required field
	LaunchConfig *DeploymentLaunchConfig `locationName:"launchConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeploymentApplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentApplicationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeploymentApplicationConfig"}

	if s.Application == nil {
		invalidParams.Add(aws.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Application", 1))
	}

	if s.ApplicationVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationVersion"))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if s.LaunchConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchConfig"))
	}
	if s.LaunchConfig != nil {
		if err := s.LaunchConfig.Validate(); err != nil {
			invalidParams.AddNested("LaunchConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeploymentApplicationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Application != nil {
		v := *s.Application

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "application", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationVersion != nil {
		v := *s.ApplicationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchConfig != nil {
		v := s.LaunchConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "launchConfig", v, metadata)
	}
	return nil
}

// Information about a deployment configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeploymentConfig
type DeploymentConfig struct {
	_ struct{} `type:"structure"`

	// The percentage of robots receiving the deployment at the same time.
	ConcurrentDeploymentPercentage *int64 `locationName:"concurrentDeploymentPercentage" min:"1" type:"integer"`

	// The percentage of deployments that need to fail before stopping deployment.
	FailureThresholdPercentage *int64 `locationName:"failureThresholdPercentage" min:"1" type:"integer"`
}

// String returns the string representation
func (s DeploymentConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeploymentConfig"}
	if s.ConcurrentDeploymentPercentage != nil && *s.ConcurrentDeploymentPercentage < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ConcurrentDeploymentPercentage", 1))
	}
	if s.FailureThresholdPercentage != nil && *s.FailureThresholdPercentage < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FailureThresholdPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeploymentConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConcurrentDeploymentPercentage != nil {
		v := *s.ConcurrentDeploymentPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "concurrentDeploymentPercentage", protocol.Int64Value(v), metadata)
	}
	if s.FailureThresholdPercentage != nil {
		v := *s.FailureThresholdPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureThresholdPercentage", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about a deployment job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeploymentJob
type DeploymentJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deployment job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the deployment job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The deployment application configuration.
	DeploymentApplicationConfigs []DeploymentApplicationConfig `locationName:"deploymentApplicationConfigs" min:"1" type:"list"`

	// The deployment configuration.
	DeploymentConfig *DeploymentConfig `locationName:"deploymentConfig" type:"structure"`

	// The deployment job failure code.
	FailureCode DeploymentJobErrorCode `locationName:"failureCode" type:"string" enum:"true"`

	// A short description of the reason why the deployment job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The Amazon Resource Name (ARN) of the fleet.
	Fleet *string `locationName:"fleet" min:"1" type:"string"`

	// The status of the deployment job.
	Status DeploymentStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s DeploymentJob) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeploymentJob) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.DeploymentApplicationConfigs) > 0 {
		v := s.DeploymentApplicationConfigs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "deploymentApplicationConfigs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DeploymentConfig != nil {
		v := s.DeploymentConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "deploymentConfig", v, metadata)
	}
	if len(s.FailureCode) > 0 {
		v := s.FailureCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Fleet != nil {
		v := *s.Fleet

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fleet", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Configuration information for a deployment launch.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeploymentLaunchConfig
type DeploymentLaunchConfig struct {
	_ struct{} `type:"structure"`

	// An array of key/value pairs specifying environment variables for the robot
	// application
	EnvironmentVariables map[string]string `locationName:"environmentVariables" type:"map"`

	// The launch file name.
	//
	// LaunchFile is a required field
	LaunchFile *string `locationName:"launchFile" min:"1" type:"string" required:"true"`

	// The package name.
	//
	// PackageName is a required field
	PackageName *string `locationName:"packageName" min:"1" type:"string" required:"true"`

	// The deployment post-launch file. This file will be executed after the launch
	// file.
	PostLaunchFile *string `locationName:"postLaunchFile" min:"1" type:"string"`

	// The deployment pre-launch file. This file will be executed prior to the launch
	// file.
	PreLaunchFile *string `locationName:"preLaunchFile" min:"1" type:"string"`
}

// String returns the string representation
func (s DeploymentLaunchConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentLaunchConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeploymentLaunchConfig"}

	if s.LaunchFile == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchFile"))
	}
	if s.LaunchFile != nil && len(*s.LaunchFile) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchFile", 1))
	}

	if s.PackageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PackageName", 1))
	}
	if s.PostLaunchFile != nil && len(*s.PostLaunchFile) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PostLaunchFile", 1))
	}
	if s.PreLaunchFile != nil && len(*s.PreLaunchFile) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PreLaunchFile", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeploymentLaunchConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EnvironmentVariables) > 0 {
		v := s.EnvironmentVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "environmentVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.LaunchFile != nil {
		v := *s.LaunchFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "launchFile", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageName != nil {
		v := *s.PackageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "packageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PostLaunchFile != nil {
		v := *s.PostLaunchFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "postLaunchFile", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PreLaunchFile != nil {
		v := *s.PreLaunchFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "preLaunchFile", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a filter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/Filter
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A list of values.
	Values []string `locationName:"values" min:"1" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Filter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Values) > 0 {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about a fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/Fleet
type Fleet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the fleet was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the last deployment job.
	LastDeploymentJob *string `locationName:"lastDeploymentJob" min:"1" type:"string"`

	// The status of the last fleet deployment.
	LastDeploymentStatus DeploymentStatus `locationName:"lastDeploymentStatus" type:"string" enum:"true"`

	// The time of the last deployment.
	LastDeploymentTime *time.Time `locationName:"lastDeploymentTime" type:"timestamp" timestampFormat:"unix"`

	// The name of the fleet.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s Fleet) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Fleet) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastDeploymentJob != nil {
		v := *s.LastDeploymentJob

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentJob", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LastDeploymentStatus) > 0 {
		v := s.LastDeploymentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LastDeploymentTime != nil {
		v := *s.LastDeploymentTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a launch configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/LaunchConfig
type LaunchConfig struct {
	_ struct{} `type:"structure"`

	// The environment variables for the application launch.
	EnvironmentVariables map[string]string `locationName:"environmentVariables" type:"map"`

	// The launch file name.
	//
	// LaunchFile is a required field
	LaunchFile *string `locationName:"launchFile" min:"1" type:"string" required:"true"`

	// The package name.
	//
	// PackageName is a required field
	PackageName *string `locationName:"packageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LaunchConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchConfig"}

	if s.LaunchFile == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchFile"))
	}
	if s.LaunchFile != nil && len(*s.LaunchFile) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchFile", 1))
	}

	if s.PackageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PackageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LaunchConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EnvironmentVariables) > 0 {
		v := s.EnvironmentVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "environmentVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.LaunchFile != nil {
		v := *s.LaunchFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "launchFile", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageName != nil {
		v := *s.PackageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "packageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The output location.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/OutputLocation
type OutputLocation struct {
	_ struct{} `type:"structure"`

	// The S3 bucket for output.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The S3 folder in the s3Bucket where output files will be placed.
	S3Prefix *string `locationName:"s3Prefix" min:"1" type:"string"`
}

// String returns the string representation
func (s OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputLocation"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Prefix != nil {
		v := *s.S3Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the progress of a deployment job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ProgressDetail
type ProgressDetail struct {
	_ struct{} `type:"structure"`

	// The current progress status.
	//
	// Validating
	//
	// Validating the deployment.
	//
	// DownloadingExtracting
	//
	// Downloading and extracting the bundle on the robot.
	//
	// ExecutingPreLaunch
	//
	// Executing pre-launch script(s) if provided.
	//
	// Launching
	//
	// Launching the robot application.
	//
	// ExecutingPostLaunch
	//
	// Executing post-launch script(s) if provided.
	//
	// Finished
	//
	// Deployment is complete.
	CurrentProgress RobotDeploymentStep `locationName:"currentProgress" type:"string" enum:"true"`

	// Estimated amount of time in seconds remaining in the step. This currently
	// only applies to the Downloading/Extracting step of the deployment. It is
	// empty for other steps.
	EstimatedTimeRemainingSeconds *int64 `locationName:"estimatedTimeRemainingSeconds" type:"integer"`

	// Precentage of the step that is done. This currently only applies to the Downloading/Extracting
	// step of the deployment. It is empty for other steps.
	PercentDone *float64 `locationName:"percentDone" type:"float"`

	// The Amazon Resource Name (ARN) of the deployment job.
	TargetResource *string `locationName:"targetResource" type:"string"`
}

// String returns the string representation
func (s ProgressDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProgressDetail) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CurrentProgress) > 0 {
		v := s.CurrentProgress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currentProgress", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EstimatedTimeRemainingSeconds != nil {
		v := *s.EstimatedTimeRemainingSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "estimatedTimeRemainingSeconds", protocol.Int64Value(v), metadata)
	}
	if s.PercentDone != nil {
		v := *s.PercentDone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "percentDone", protocol.Float64Value(v), metadata)
	}
	if s.TargetResource != nil {
		v := *s.TargetResource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetResource", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a rendering engine.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RenderingEngine
type RenderingEngine struct {
	_ struct{} `type:"structure"`

	// The name of the rendering engine.
	Name RenderingEngineType `locationName:"name" type:"string" enum:"true"`

	// The version of the rendering engine.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s RenderingEngine) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RenderingEngine) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a robot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/Robot
type Robot struct {
	_ struct{} `type:"structure"`

	// The architecture of the robot.
	Architecture Architecture `locationName:"architecture" type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the robot.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the fleet.
	FleetArn *string `locationName:"fleetArn" min:"1" type:"string"`

	// The Greengrass group associated with the robot.
	GreenGrassGroupId *string `locationName:"greenGrassGroupId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the last deployment job.
	LastDeploymentJob *string `locationName:"lastDeploymentJob" min:"1" type:"string"`

	// The time of the last deployment.
	LastDeploymentTime *time.Time `locationName:"lastDeploymentTime" type:"timestamp" timestampFormat:"unix"`

	// The name of the robot.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the robot.
	Status RobotStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s Robot) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Robot) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Architecture) > 0 {
		v := s.Architecture

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "architecture", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GreenGrassGroupId != nil {
		v := *s.GreenGrassGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "greenGrassGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastDeploymentJob != nil {
		v := *s.LastDeploymentJob

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentJob", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastDeploymentTime != nil {
		v := *s.LastDeploymentTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Application configuration information for a robot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RobotApplicationConfig
type RobotApplicationConfig struct {
	_ struct{} `type:"structure"`

	// The application information for the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the robot application.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`

	// The launch configuration for the robot application.
	//
	// LaunchConfig is a required field
	LaunchConfig *LaunchConfig `locationName:"launchConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s RobotApplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RobotApplicationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RobotApplicationConfig"}

	if s.Application == nil {
		invalidParams.Add(aws.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if s.LaunchConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchConfig"))
	}
	if s.LaunchConfig != nil {
		if err := s.LaunchConfig.Validate(); err != nil {
			invalidParams.AddNested("LaunchConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RobotApplicationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Application != nil {
		v := *s.Application

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "application", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationVersion != nil {
		v := *s.ApplicationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchConfig != nil {
		v := s.LaunchConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "launchConfig", v, metadata)
	}
	return nil
}

// Summary information for a robot application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RobotApplicationSummary
type RobotApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot application was
	// last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// The name of the robot application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Information about a robot software suite.
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The version of the robot application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s RobotApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RobotApplicationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RobotSoftwareSuite != nil {
		v := s.RobotSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "robotSoftwareSuite", v, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a robot deployment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RobotDeployment
type RobotDeployment struct {
	_ struct{} `type:"structure"`

	// The robot deployment Amazon Resource Name (ARN).
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the deployment finished.
	DeploymentFinishTime *time.Time `locationName:"deploymentFinishTime" type:"timestamp" timestampFormat:"unix"`

	// The time, in milliseconds since the epoch, when the deployment was started.
	DeploymentStartTime *time.Time `locationName:"deploymentStartTime" type:"timestamp" timestampFormat:"unix"`

	// The robot deployment failure code.
	FailureCode DeploymentJobErrorCode `locationName:"failureCode" type:"string" enum:"true"`

	// A short description of the reason why the robot deployment failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// Information about how the deployment is progressing.
	ProgressDetail *ProgressDetail `locationName:"progressDetail" type:"structure"`

	// The status of the robot deployment.
	Status RobotStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s RobotDeployment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RobotDeployment) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeploymentFinishTime != nil {
		v := *s.DeploymentFinishTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentFinishTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.DeploymentStartTime != nil {
		v := *s.DeploymentStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentStartTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.FailureCode) > 0 {
		v := s.FailureCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProgressDetail != nil {
		v := s.ProgressDetail

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "progressDetail", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about a robot software suite.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RobotSoftwareSuite
type RobotSoftwareSuite struct {
	_ struct{} `type:"structure"`

	// The name of the robot software suite.
	Name RobotSoftwareSuiteType `locationName:"name" type:"string" enum:"true"`

	// The version of the robot software suite.
	Version RobotSoftwareSuiteVersionType `locationName:"version" type:"string" enum:"true"`
}

// String returns the string representation
func (s RobotSoftwareSuite) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RobotSoftwareSuite) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Version) > 0 {
		v := s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about a simulation application configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SimulationApplicationConfig
type SimulationApplicationConfig struct {
	_ struct{} `type:"structure"`

	// The application information for the simulation application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the simulation application.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`

	// The launch configuration for the simulation application.
	//
	// LaunchConfig is a required field
	LaunchConfig *LaunchConfig `locationName:"launchConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s SimulationApplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimulationApplicationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SimulationApplicationConfig"}

	if s.Application == nil {
		invalidParams.Add(aws.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if s.LaunchConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchConfig"))
	}
	if s.LaunchConfig != nil {
		if err := s.LaunchConfig.Validate(); err != nil {
			invalidParams.AddNested("LaunchConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationApplicationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Application != nil {
		v := *s.Application

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "application", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationVersion != nil {
		v := *s.ApplicationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchConfig != nil {
		v := s.LaunchConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "launchConfig", v, metadata)
	}
	return nil
}

// Summary information for a simulation application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SimulationApplicationSummary
type SimulationApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation application
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// The name of the simulation application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Information about a robot software suite.
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// Information about a simulation software suite.
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure"`

	// The version of the simulation application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s SimulationApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationApplicationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RobotSoftwareSuite != nil {
		v := s.RobotSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "robotSoftwareSuite", v, metadata)
	}
	if s.SimulationSoftwareSuite != nil {
		v := s.SimulationSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "simulationSoftwareSuite", v, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a simulation job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SimulationJob
type SimulationJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// A unique identifier for this SimulationJob request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The failure behavior the simulation job.
	//
	// Continue
	//
	// Restart the simulation job in the same host instance.
	//
	// Fail
	//
	// Stop the simulation job and terminate the instance.
	FailureBehavior FailureBehavior `locationName:"failureBehavior" type:"string" enum:"true"`

	// The failure code of the simulation job if it failed.
	FailureCode SimulationJobErrorCode `locationName:"failureCode" type:"string" enum:"true"`

	// The reason why the simulation job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The IAM role that allows the simulation instance to call the AWS APIs that
	// are specified in its associated policies on your behalf. This is how credentials
	// are passed in to your simulation job.
	IamRole *string `locationName:"iamRole" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// started.
	LastStartedAt *time.Time `locationName:"lastStartedAt" type:"timestamp" timestampFormat:"unix"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// The maximum simulation job duration in seconds. The value must be 8 days
	// (691,200 seconds) or less.
	MaxJobDurationInSeconds *int64 `locationName:"maxJobDurationInSeconds" type:"long"`

	// The name of the simulation job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Location for output files generated by the simulation job.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// A list of robot applications.
	RobotApplications []RobotApplicationConfig `locationName:"robotApplications" min:"1" type:"list"`

	// A list of simulation applications.
	SimulationApplications []SimulationApplicationConfig `locationName:"simulationApplications" min:"1" type:"list"`

	// The simulation job execution duration in milliseconds.
	SimulationTimeMillis *int64 `locationName:"simulationTimeMillis" type:"long"`

	// Status of the simulation job.
	Status SimulationJobStatus `locationName:"status" type:"string" enum:"true"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// job.
	Tags map[string]string `locationName:"tags" type:"map"`

	// VPC configuration information.
	VpcConfig *VPCConfigResponse `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s SimulationJob) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationJob) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientRequestToken != nil {
		v := *s.ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.FailureBehavior) > 0 {
		v := s.FailureBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.FailureCode) > 0 {
		v := s.FailureCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IamRole != nil {
		v := *s.IamRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "iamRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastStartedAt != nil {
		v := *s.LastStartedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastStartedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.MaxJobDurationInSeconds != nil {
		v := *s.MaxJobDurationInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxJobDurationInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutputLocation != nil {
		v := s.OutputLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "outputLocation", v, metadata)
	}
	if len(s.RobotApplications) > 0 {
		v := s.RobotApplications

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "robotApplications", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.SimulationApplications) > 0 {
		v := s.SimulationApplications

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "simulationApplications", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SimulationTimeMillis != nil {
		v := *s.SimulationTimeMillis

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "simulationTimeMillis", protocol.Int64Value(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "vpcConfig", v, metadata)
	}
	return nil
}

// Summary information for a simulation job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SimulationJobSummary
type SimulationJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// The name of the simulation job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A list of simulation job robot application names.
	RobotApplicationNames []string `locationName:"robotApplicationNames" min:"1" type:"list"`

	// A list of simulation job simulation application names.
	SimulationApplicationNames []string `locationName:"simulationApplicationNames" min:"1" type:"list"`

	// The status of the simulation job.
	Status SimulationJobStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s SimulationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationJobSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RobotApplicationNames) > 0 {
		v := s.RobotApplicationNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "robotApplicationNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.SimulationApplicationNames) > 0 {
		v := s.SimulationApplicationNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "simulationApplicationNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about a simulation software suite.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SimulationSoftwareSuite
type SimulationSoftwareSuite struct {
	_ struct{} `type:"structure"`

	// The name of the simulation software suite.
	Name SimulationSoftwareSuiteType `locationName:"name" type:"string" enum:"true"`

	// The version of the simulation software suite.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s SimulationSoftwareSuite) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationSoftwareSuite) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/Source
type Source struct {
	_ struct{} `type:"structure"`

	// The taget processor architecture for the application.
	Architecture Architecture `locationName:"architecture" type:"string" enum:"true"`

	// A hash of the object specified by s3Bucket and s3Key.
	Etag *string `locationName:"etag" type:"string"`

	// The s3 bucket name.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The s3 object key.
	S3Key *string `locationName:"s3Key" min:"1" type:"string"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Source) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Architecture) > 0 {
		v := s.Architecture

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "architecture", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Etag != nil {
		v := *s.Etag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "etag", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a source configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SourceConfig
type SourceConfig struct {
	_ struct{} `type:"structure"`

	// The target processor architecture for the application.
	Architecture Architecture `locationName:"architecture" type:"string" enum:"true"`

	// The Amazon S3 bucket name.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The s3 object key.
	S3Key *string `locationName:"s3Key" min:"1" type:"string"`
}

// String returns the string representation
func (s SourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceConfig"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SourceConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Architecture) > 0 {
		v := s.Architecture

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "architecture", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// If your simulation job accesses resources in a VPC, you provide this parameter
// identifying the list of security group IDs and subnet IDs. These must belong
// to the same VPC. You must provide at least one security group and two subnet
// IDs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/VPCConfig
type VPCConfig struct {
	_ struct{} `type:"structure"`

	// A boolean indicating whether to assign a public IP address.
	AssignPublicIp *bool `locationName:"assignPublicIp" type:"boolean"`

	// A list of one or more security groups IDs in your VPC.
	SecurityGroups []string `locationName:"securityGroups" min:"1" type:"list"`

	// A list of one or more subnet IDs in your VPC.
	//
	// Subnets is a required field
	Subnets []string `locationName:"subnets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s VPCConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VPCConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VPCConfig"}
	if s.SecurityGroups != nil && len(s.SecurityGroups) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityGroups", 1))
	}

	if s.Subnets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subnets"))
	}
	if s.Subnets != nil && len(s.Subnets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Subnets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VPCConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssignPublicIp != nil {
		v := *s.AssignPublicIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assignPublicIp", protocol.BoolValue(v), metadata)
	}
	if len(s.SecurityGroups) > 0 {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Subnets) > 0 {
		v := s.Subnets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// VPC configuration associated with your simulation job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/VPCConfigResponse
type VPCConfigResponse struct {
	_ struct{} `type:"structure"`

	// A boolean indicating if a public IP was assigned.
	AssignPublicIp *bool `locationName:"assignPublicIp" type:"boolean"`

	// A list of security group IDs associated with the simulation job.
	SecurityGroups []string `locationName:"securityGroups" min:"1" type:"list"`

	// A list of subnet IDs associated with the simulation job.
	Subnets []string `locationName:"subnets" min:"1" type:"list"`

	// The VPC ID associated with your simulation job.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VPCConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VPCConfigResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssignPublicIp != nil {
		v := *s.AssignPublicIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assignPublicIp", protocol.BoolValue(v), metadata)
	}
	if len(s.SecurityGroups) > 0 {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Subnets) > 0 {
		v := s.Subnets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
