// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A complex type that contains information about the request to authorize associating
// a VPC with your private hosted zone. Authorization is only required when
// a private hosted zone and a VPC were created by using different accounts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorizationRequest
type CreateVPCAssociationAuthorizationInput struct {
	_ struct{} `locationName:"CreateVPCAssociationAuthorizationRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The ID of the private hosted zone that you want to authorize associating
	// a VPC with.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// A complex type that contains the VPC ID and region for the VPC that you want
	// to authorize associating with your hosted zone.
	//
	// VPC is a required field
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVPCAssociationAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVPCAssociationAuthorizationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateVPCAssociationAuthorizationInput"}

	if s.HostedZoneId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostedZoneId"))
	}

	if s.VPC == nil {
		invalidParams.Add(aws.NewErrParamRequired("VPC"))
	}
	if s.VPC != nil {
		if err := s.VPC.Validate(); err != nil {
			invalidParams.AddNested("VPC", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVPCAssociationAuthorizationInput) MarshalFields(e protocol.FieldEncoder) error {

	e.SetFields(protocol.BodyTarget, "CreateVPCAssociationAuthorizationRequest", protocol.FieldMarshalerFunc(func(e protocol.FieldEncoder) error {
		if s.VPC != nil {
			v := s.VPC

			metadata := protocol.Metadata{}
			e.SetFields(protocol.BodyTarget, "VPC", v, metadata)
		}
		return nil
	}), protocol.Metadata{XMLNamespaceURI: "https://route53.amazonaws.com/doc/2013-04-01/"})
	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains the response information from a CreateVPCAssociationAuthorization
// request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorizationResponse
type CreateVPCAssociationAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that you authorized associating a VPC with.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The VPC that you authorized associating with a hosted zone.
	//
	// VPC is a required field
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVPCAssociationAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVPCAssociationAuthorizationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostedZoneId", protocol.StringValue(v), metadata)
	}
	if s.VPC != nil {
		v := s.VPC

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VPC", v, metadata)
	}
	return nil
}

const opCreateVPCAssociationAuthorization = "CreateVPCAssociationAuthorization"

// CreateVPCAssociationAuthorizationRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Authorizes the AWS account that created a specified VPC to submit an AssociateVPCWithHostedZone
// request to associate the VPC with a specified hosted zone that was created
// by a different account. To submit a CreateVPCAssociationAuthorization request,
// you must use the account that created the hosted zone. After you authorize
// the association, use the account that created the VPC to submit an AssociateVPCWithHostedZone
// request.
//
// If you want to associate multiple VPCs that you created by using one account
// with a hosted zone that you created by using a different account, you must
// submit one authorization request for each VPC.
//
//    // Example sending a request using CreateVPCAssociationAuthorizationRequest.
//    req := client.CreateVPCAssociationAuthorizationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorization
func (c *Client) CreateVPCAssociationAuthorizationRequest(input *CreateVPCAssociationAuthorizationInput) CreateVPCAssociationAuthorizationRequest {
	op := &aws.Operation{
		Name:       opCreateVPCAssociationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/authorizevpcassociation",
	}

	if input == nil {
		input = &CreateVPCAssociationAuthorizationInput{}
	}

	req := c.newRequest(op, input, &CreateVPCAssociationAuthorizationOutput{})
	return CreateVPCAssociationAuthorizationRequest{Request: req, Input: input, Copy: c.CreateVPCAssociationAuthorizationRequest}
}

// CreateVPCAssociationAuthorizationRequest is the request type for the
// CreateVPCAssociationAuthorization API operation.
type CreateVPCAssociationAuthorizationRequest struct {
	*aws.Request
	Input *CreateVPCAssociationAuthorizationInput
	Copy  func(*CreateVPCAssociationAuthorizationInput) CreateVPCAssociationAuthorizationRequest
}

// Send marshals and sends the CreateVPCAssociationAuthorization API request.
func (r CreateVPCAssociationAuthorizationRequest) Send(ctx context.Context) (*CreateVPCAssociationAuthorizationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateVPCAssociationAuthorizationResponse{
		CreateVPCAssociationAuthorizationOutput: r.Request.Data.(*CreateVPCAssociationAuthorizationOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateVPCAssociationAuthorizationResponse is the response type for the
// CreateVPCAssociationAuthorization API operation.
type CreateVPCAssociationAuthorizationResponse struct {
	*CreateVPCAssociationAuthorizationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateVPCAssociationAuthorization request.
func (r *CreateVPCAssociationAuthorizationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
