// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifactInput
type DescribeProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the provisioning artifact.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`

	// Indicates whether a verbose level of detail is enabled.
	Verbose *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProvisioningArtifactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProvisioningArtifactInput"}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}

	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifactOutput
type DescribeProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`

	// The URL of the CloudFormation template in Amazon S3.
	Info map[string]string `min:"1" type:"map"`

	// Information about the provisioning artifact.
	ProvisioningArtifactDetail *ProvisioningArtifactDetail `type:"structure"`

	// The status of the current request.
	Status Status `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeProvisioningArtifact = "DescribeProvisioningArtifact"

// DescribeProvisioningArtifactRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Gets information about the specified provisioning artifact (also known as
// a version) for the specified product.
//
//    // Example sending a request using DescribeProvisioningArtifactRequest.
//    req := client.DescribeProvisioningArtifactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifact
func (c *Client) DescribeProvisioningArtifactRequest(input *DescribeProvisioningArtifactInput) DescribeProvisioningArtifactRequest {
	op := &aws.Operation{
		Name:       opDescribeProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProvisioningArtifactInput{}
	}

	req := c.newRequest(op, input, &DescribeProvisioningArtifactOutput{})
	return DescribeProvisioningArtifactRequest{Request: req, Input: input, Copy: c.DescribeProvisioningArtifactRequest}
}

// DescribeProvisioningArtifactRequest is the request type for the
// DescribeProvisioningArtifact API operation.
type DescribeProvisioningArtifactRequest struct {
	*aws.Request
	Input *DescribeProvisioningArtifactInput
	Copy  func(*DescribeProvisioningArtifactInput) DescribeProvisioningArtifactRequest
}

// Send marshals and sends the DescribeProvisioningArtifact API request.
func (r DescribeProvisioningArtifactRequest) Send(ctx context.Context) (*DescribeProvisioningArtifactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProvisioningArtifactResponse{
		DescribeProvisioningArtifactOutput: r.Request.Data.(*DescribeProvisioningArtifactOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeProvisioningArtifactResponse is the response type for the
// DescribeProvisioningArtifact API operation.
type DescribeProvisioningArtifactResponse struct {
	*DescribeProvisioningArtifactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProvisioningArtifact request.
func (r *DescribeProvisioningArtifactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
