// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTaskInput
type GetActivityTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned
	// when you create the task using CreateActivity.)
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// You can provide an arbitrary name in order to identify the worker that the
	// task is assigned to. This name is used when it is logged in the execution
	// history.
	WorkerName *string `locationName:"workerName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetActivityTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetActivityTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetActivityTaskInput"}

	if s.ActivityArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActivityArn"))
	}
	if s.ActivityArn != nil && len(*s.ActivityArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ActivityArn", 1))
	}
	if s.WorkerName != nil && len(*s.WorkerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTaskOutput
type GetActivityTaskOutput struct {
	_ struct{} `type:"structure"`

	// The string that contains the JSON input data for the task.
	Input *string `locationName:"input" type:"string"`

	// A token that identifies the scheduled task. This token must be copied and
	// included in subsequent calls to SendTaskHeartbeat, SendTaskSuccess or SendTaskFailure
	// in order to report the progress or completion of the task.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetActivityTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetActivityTask = "GetActivityTask"

// GetActivityTaskRequest returns a request value for making API operation for
// AWS Step Functions.
//
// Used by workers to retrieve a task (with the specified activity ARN) which
// has been scheduled for execution by a running state machine. This initiates
// a long poll, where the service holds the HTTP connection open and responds
// as soon as a task becomes available (i.e. an execution of a task of this
// type is needed.) The maximum time the service holds on to the request before
// responding is 60 seconds. If no task is available within 60 seconds, the
// poll returns a taskToken with a null string.
//
// Workers should set their client side socket timeout to at least 65 seconds
// (5 seconds higher than the maximum time the service may hold the poll request).
//
// Polling with GetActivityTask can cause latency in some implementations. See
// Avoid Latency When Polling for Activity Tasks (https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html)
// in the Step Functions Developer Guide.
//
//    // Example sending a request using GetActivityTaskRequest.
//    req := client.GetActivityTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTask
func (c *Client) GetActivityTaskRequest(input *GetActivityTaskInput) GetActivityTaskRequest {
	op := &aws.Operation{
		Name:       opGetActivityTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetActivityTaskInput{}
	}

	req := c.newRequest(op, input, &GetActivityTaskOutput{})
	return GetActivityTaskRequest{Request: req, Input: input, Copy: c.GetActivityTaskRequest}
}

// GetActivityTaskRequest is the request type for the
// GetActivityTask API operation.
type GetActivityTaskRequest struct {
	*aws.Request
	Input *GetActivityTaskInput
	Copy  func(*GetActivityTaskInput) GetActivityTaskRequest
}

// Send marshals and sends the GetActivityTask API request.
func (r GetActivityTaskRequest) Send(ctx context.Context) (*GetActivityTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetActivityTaskResponse{
		GetActivityTaskOutput: r.Request.Data.(*GetActivityTaskOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetActivityTaskResponse is the response type for the
// GetActivityTask API operation.
type GetActivityTaskResponse struct {
	*GetActivityTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetActivityTask request.
func (r *GetActivityTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
