package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAntChain invokes the baas.UpdateAntChain API synchronously
// api document: https://help.aliyun.com/api/baas/updateantchain.html
func (client *Client) UpdateAntChain(request *UpdateAntChainRequest) (response *UpdateAntChainResponse, err error) {
	response = CreateUpdateAntChainResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAntChainWithChan invokes the baas.UpdateAntChain API asynchronously
// api document: https://help.aliyun.com/api/baas/updateantchain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAntChainWithChan(request *UpdateAntChainRequest) (<-chan *UpdateAntChainResponse, <-chan error) {
	responseChan := make(chan *UpdateAntChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAntChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAntChainWithCallback invokes the baas.UpdateAntChain API asynchronously
// api document: https://help.aliyun.com/api/baas/updateantchain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAntChainWithCallback(request *UpdateAntChainRequest, callback func(response *UpdateAntChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAntChainResponse
		var err error
		defer close(result)
		response, err = client.UpdateAntChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAntChainRequest is the request struct for api UpdateAntChain
type UpdateAntChainRequest struct {
	*requests.RpcRequest
	AntChainName string `position:"Body" name:"AntChainName"`
	AntChainId   string `position:"Body" name:"AntChainId"`
}

// UpdateAntChainResponse is the response struct for api UpdateAntChain
type UpdateAntChainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateUpdateAntChainRequest creates a request to invoke UpdateAntChain API
func CreateUpdateAntChainRequest() (request *UpdateAntChainRequest) {
	request = &UpdateAntChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "UpdateAntChain", "baas", "openAPI")
	return
}

// CreateUpdateAntChainResponse creates a response to parse from UpdateAntChain response
func CreateUpdateAntChainResponse() (response *UpdateAntChainResponse) {
	response = &UpdateAntChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
