package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PredictiveRecordSuccess invokes the ccc.PredictiveRecordSuccess API synchronously
// api document: https://help.aliyun.com/api/ccc/predictiverecordsuccess.html
func (client *Client) PredictiveRecordSuccess(request *PredictiveRecordSuccessRequest) (response *PredictiveRecordSuccessResponse, err error) {
	response = CreatePredictiveRecordSuccessResponse()
	err = client.DoAction(request, response)
	return
}

// PredictiveRecordSuccessWithChan invokes the ccc.PredictiveRecordSuccess API asynchronously
// api document: https://help.aliyun.com/api/ccc/predictiverecordsuccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PredictiveRecordSuccessWithChan(request *PredictiveRecordSuccessRequest) (<-chan *PredictiveRecordSuccessResponse, <-chan error) {
	responseChan := make(chan *PredictiveRecordSuccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PredictiveRecordSuccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PredictiveRecordSuccessWithCallback invokes the ccc.PredictiveRecordSuccess API asynchronously
// api document: https://help.aliyun.com/api/ccc/predictiverecordsuccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PredictiveRecordSuccessWithCallback(request *PredictiveRecordSuccessRequest, callback func(response *PredictiveRecordSuccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PredictiveRecordSuccessResponse
		var err error
		defer close(result)
		response, err = client.PredictiveRecordSuccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PredictiveRecordSuccessRequest is the request struct for api PredictiveRecordSuccess
type PredictiveRecordSuccessRequest struct {
	*requests.RpcRequest
	CallId             string           `position:"Query" name:"CallId"`
	CallingNumber      string           `position:"Query" name:"CallingNumber"`
	InstanceId         string           `position:"Query" name:"InstanceId"`
	CalledNumber       string           `position:"Query" name:"CalledNumber"`
	CallType           string           `position:"Query" name:"CallType"`
	ScenarioId         string           `position:"Query" name:"ScenarioId"`
	TaskId             string           `position:"Query" name:"TaskId"`
	CabInstanceId      string           `position:"Query" name:"CabInstanceId"`
	CabInstanceOwnerId requests.Integer `position:"Query" name:"CabInstanceOwnerId"`
}

// PredictiveRecordSuccessResponse is the response struct for api PredictiveRecordSuccess
type PredictiveRecordSuccessResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreatePredictiveRecordSuccessRequest creates a request to invoke PredictiveRecordSuccess API
func CreatePredictiveRecordSuccessRequest() (request *PredictiveRecordSuccessRequest) {
	request = &PredictiveRecordSuccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "PredictiveRecordSuccess", "", "")
	return
}

// CreatePredictiveRecordSuccessResponse creates a response to parse from PredictiveRecordSuccess response
func CreatePredictiveRecordSuccessResponse() (response *PredictiveRecordSuccessResponse) {
	response = &PredictiveRecordSuccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
