package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableRealtimeLogDelivery invokes the cdn.EnableRealtimeLogDelivery API synchronously
// api document: https://help.aliyun.com/api/cdn/enablerealtimelogdelivery.html
func (client *Client) EnableRealtimeLogDelivery(request *EnableRealtimeLogDeliveryRequest) (response *EnableRealtimeLogDeliveryResponse, err error) {
	response = CreateEnableRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// EnableRealtimeLogDeliveryWithChan invokes the cdn.EnableRealtimeLogDelivery API asynchronously
// api document: https://help.aliyun.com/api/cdn/enablerealtimelogdelivery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableRealtimeLogDeliveryWithChan(request *EnableRealtimeLogDeliveryRequest) (<-chan *EnableRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *EnableRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableRealtimeLogDeliveryWithCallback invokes the cdn.EnableRealtimeLogDelivery API asynchronously
// api document: https://help.aliyun.com/api/cdn/enablerealtimelogdelivery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableRealtimeLogDeliveryWithCallback(request *EnableRealtimeLogDeliveryRequest, callback func(response *EnableRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.EnableRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableRealtimeLogDeliveryRequest is the request struct for api EnableRealtimeLogDelivery
type EnableRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	Domain  string           `position:"Query" name:"Domain"`
}

// EnableRealtimeLogDeliveryResponse is the response struct for api EnableRealtimeLogDelivery
type EnableRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableRealtimeLogDeliveryRequest creates a request to invoke EnableRealtimeLogDelivery API
func CreateEnableRealtimeLogDeliveryRequest() (request *EnableRealtimeLogDeliveryRequest) {
	request = &EnableRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "EnableRealtimeLogDelivery", "", "")
	return
}

// CreateEnableRealtimeLogDeliveryResponse creates a response to parse from EnableRealtimeLogDelivery response
func CreateEnableRealtimeLogDeliveryResponse() (response *EnableRealtimeLogDeliveryResponse) {
	response = &EnableRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
