package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopDeletemarketing invokes the cloudwf.ShopDeletemarketing API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopdeletemarketing.html
func (client *Client) ShopDeletemarketing(request *ShopDeletemarketingRequest) (response *ShopDeletemarketingResponse, err error) {
	response = CreateShopDeletemarketingResponse()
	err = client.DoAction(request, response)
	return
}

// ShopDeletemarketingWithChan invokes the cloudwf.ShopDeletemarketing API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopdeletemarketing.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopDeletemarketingWithChan(request *ShopDeletemarketingRequest) (<-chan *ShopDeletemarketingResponse, <-chan error) {
	responseChan := make(chan *ShopDeletemarketingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopDeletemarketing(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopDeletemarketingWithCallback invokes the cloudwf.ShopDeletemarketing API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopdeletemarketing.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopDeletemarketingWithCallback(request *ShopDeletemarketingRequest, callback func(response *ShopDeletemarketingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopDeletemarketingResponse
		var err error
		defer close(result)
		response, err = client.ShopDeletemarketing(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopDeletemarketingRequest is the request struct for api ShopDeletemarketing
type ShopDeletemarketingRequest struct {
	*requests.RpcRequest
	Id  requests.Integer `position:"Query" name:"Id"`
	Sid requests.Integer `position:"Query" name:"Sid"`
}

// ShopDeletemarketingResponse is the response struct for api ShopDeletemarketing
type ShopDeletemarketingResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopDeletemarketingRequest creates a request to invoke ShopDeletemarketing API
func CreateShopDeletemarketingRequest() (request *ShopDeletemarketingRequest) {
	request = &ShopDeletemarketingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopDeletemarketing", "cloudwf", "openAPI")
	return
}

// CreateShopDeletemarketingResponse creates a response to parse from ShopDeletemarketing response
func CreateShopDeletemarketingResponse() (response *ShopDeletemarketingResponse) {
	response = &ShopDeletemarketingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
