package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNamespace invokes the cr.ListNamespace API synchronously
// api document: https://help.aliyun.com/api/cr/listnamespace.html
func (client *Client) ListNamespace(request *ListNamespaceRequest) (response *ListNamespaceResponse, err error) {
	response = CreateListNamespaceResponse()
	err = client.DoAction(request, response)
	return
}

// ListNamespaceWithChan invokes the cr.ListNamespace API asynchronously
// api document: https://help.aliyun.com/api/cr/listnamespace.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNamespaceWithChan(request *ListNamespaceRequest) (<-chan *ListNamespaceResponse, <-chan error) {
	responseChan := make(chan *ListNamespaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNamespace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNamespaceWithCallback invokes the cr.ListNamespace API asynchronously
// api document: https://help.aliyun.com/api/cr/listnamespace.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNamespaceWithCallback(request *ListNamespaceRequest, callback func(response *ListNamespaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNamespaceResponse
		var err error
		defer close(result)
		response, err = client.ListNamespace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNamespaceRequest is the request struct for api ListNamespace
type ListNamespaceRequest struct {
	*requests.RpcRequest
	NamespaceName   string           `position:"Query" name:"NamespaceName"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	PageNo          requests.Integer `position:"Query" name:"PageNo"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	NamespaceStatus string           `position:"Query" name:"NamespaceStatus"`
}

// ListNamespaceResponse is the response struct for api ListNamespace
type ListNamespaceResponse struct {
	*responses.BaseResponse
	ListNamespaceIsSuccess bool             `json:"IsSuccess" xml:"IsSuccess"`
	Code                   string           `json:"Code" xml:"Code"`
	RequestId              string           `json:"RequestId" xml:"RequestId"`
	PageNo                 int              `json:"PageNo" xml:"PageNo"`
	PageSize               int              `json:"PageSize" xml:"PageSize"`
	TotalCount             string           `json:"TotalCount" xml:"TotalCount"`
	Namespaces             []NamespacesItem `json:"Namespaces" xml:"Namespaces"`
}

// CreateListNamespaceRequest creates a request to invoke ListNamespace API
func CreateListNamespaceRequest() (request *ListNamespaceRequest) {
	request = &ListNamespaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "ListNamespace", "cr", "openAPI")
	return
}

// CreateListNamespaceResponse creates a response to parse from ListNamespace response
func CreateListNamespaceResponse() (response *ListNamespaceResponse) {
	response = &ListNamespaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
