package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnIpaService invokes the dcdn.DescribeDcdnIpaService API synchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdnipaservice.html
func (client *Client) DescribeDcdnIpaService(request *DescribeDcdnIpaServiceRequest) (response *DescribeDcdnIpaServiceResponse, err error) {
	response = CreateDescribeDcdnIpaServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnIpaServiceWithChan invokes the dcdn.DescribeDcdnIpaService API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdnipaservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnIpaServiceWithChan(request *DescribeDcdnIpaServiceRequest) (<-chan *DescribeDcdnIpaServiceResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnIpaServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnIpaService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnIpaServiceWithCallback invokes the dcdn.DescribeDcdnIpaService API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdnipaservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnIpaServiceWithCallback(request *DescribeDcdnIpaServiceRequest, callback func(response *DescribeDcdnIpaServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnIpaServiceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnIpaService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnIpaServiceRequest is the request struct for api DescribeDcdnIpaService
type DescribeDcdnIpaServiceRequest struct {
	*requests.RpcRequest
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeDcdnIpaServiceResponse is the response struct for api DescribeDcdnIpaService
type DescribeDcdnIpaServiceResponse struct {
	*responses.BaseResponse
	RequestId          string                                 `json:"RequestId" xml:"RequestId"`
	InstanceId         string                                 `json:"InstanceId" xml:"InstanceId"`
	InternetChargeType string                                 `json:"InternetChargeType" xml:"InternetChargeType"`
	OpeningTime        string                                 `json:"OpeningTime" xml:"OpeningTime"`
	ChangingChargeType string                                 `json:"ChangingChargeType" xml:"ChangingChargeType"`
	ChangingAffectTime string                                 `json:"ChangingAffectTime" xml:"ChangingAffectTime"`
	OperationLocks     OperationLocksInDescribeDcdnIpaService `json:"OperationLocks" xml:"OperationLocks"`
}

// CreateDescribeDcdnIpaServiceRequest creates a request to invoke DescribeDcdnIpaService API
func CreateDescribeDcdnIpaServiceRequest() (request *DescribeDcdnIpaServiceRequest) {
	request = &DescribeDcdnIpaServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnIpaService", "", "")
	return
}

// CreateDescribeDcdnIpaServiceResponse creates a response to parse from DescribeDcdnIpaService response
func CreateDescribeDcdnIpaServiceResponse() (response *DescribeDcdnIpaServiceResponse) {
	response = &DescribeDcdnIpaServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
