package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AsyncTaskCancel invokes the drds.AsyncTaskCancel API synchronously
// api document: https://help.aliyun.com/api/drds/asynctaskcancel.html
func (client *Client) AsyncTaskCancel(request *AsyncTaskCancelRequest) (response *AsyncTaskCancelResponse, err error) {
	response = CreateAsyncTaskCancelResponse()
	err = client.DoAction(request, response)
	return
}

// AsyncTaskCancelWithChan invokes the drds.AsyncTaskCancel API asynchronously
// api document: https://help.aliyun.com/api/drds/asynctaskcancel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AsyncTaskCancelWithChan(request *AsyncTaskCancelRequest) (<-chan *AsyncTaskCancelResponse, <-chan error) {
	responseChan := make(chan *AsyncTaskCancelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AsyncTaskCancel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AsyncTaskCancelWithCallback invokes the drds.AsyncTaskCancel API asynchronously
// api document: https://help.aliyun.com/api/drds/asynctaskcancel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AsyncTaskCancelWithCallback(request *AsyncTaskCancelRequest, callback func(response *AsyncTaskCancelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AsyncTaskCancelResponse
		var err error
		defer close(result)
		response, err = client.AsyncTaskCancel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AsyncTaskCancelRequest is the request struct for api AsyncTaskCancel
type AsyncTaskCancelRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
	TaskId         requests.Integer `position:"Query" name:"TaskId"`
}

// AsyncTaskCancelResponse is the response struct for api AsyncTaskCancel
type AsyncTaskCancelResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAsyncTaskCancelRequest creates a request to invoke AsyncTaskCancel API
func CreateAsyncTaskCancelRequest() (request *AsyncTaskCancelRequest) {
	request = &AsyncTaskCancelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "AsyncTaskCancel", "Drds", "openAPI")
	return
}

// CreateAsyncTaskCancelResponse creates a response to parse from AsyncTaskCancel response
func CreateAsyncTaskCancelResponse() (response *AsyncTaskCancelResponse) {
	response = &AsyncTaskCancelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
