package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstanceAccount invokes the drds.CreateInstanceAccount API synchronously
// api document: https://help.aliyun.com/api/drds/createinstanceaccount.html
func (client *Client) CreateInstanceAccount(request *CreateInstanceAccountRequest) (response *CreateInstanceAccountResponse, err error) {
	response = CreateCreateInstanceAccountResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstanceAccountWithChan invokes the drds.CreateInstanceAccount API asynchronously
// api document: https://help.aliyun.com/api/drds/createinstanceaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceAccountWithChan(request *CreateInstanceAccountRequest) (<-chan *CreateInstanceAccountResponse, <-chan error) {
	responseChan := make(chan *CreateInstanceAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstanceAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstanceAccountWithCallback invokes the drds.CreateInstanceAccount API asynchronously
// api document: https://help.aliyun.com/api/drds/createinstanceaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceAccountWithCallback(request *CreateInstanceAccountRequest, callback func(response *CreateInstanceAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstanceAccountResponse
		var err error
		defer close(result)
		response, err = client.CreateInstanceAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstanceAccountRequest is the request struct for api CreateInstanceAccount
type CreateInstanceAccountRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string                              `position:"Query" name:"DrdsInstanceId"`
	Password       string                              `position:"Query" name:"Password"`
	AccountName    string                              `position:"Query" name:"AccountName"`
	DbPrivilege    *[]CreateInstanceAccountDbPrivilege `position:"Query" name:"DbPrivilege"  type:"Repeated"`
}

// CreateInstanceAccountDbPrivilege is a repeated param struct in CreateInstanceAccountRequest
type CreateInstanceAccountDbPrivilege struct {
	DbName    string `name:"DbName"`
	Privilege string `name:"Privilege"`
}

// CreateInstanceAccountResponse is the response struct for api CreateInstanceAccount
type CreateInstanceAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateInstanceAccountRequest creates a request to invoke CreateInstanceAccount API
func CreateCreateInstanceAccountRequest() (request *CreateInstanceAccountRequest) {
	request = &CreateInstanceAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "CreateInstanceAccount", "Drds", "openAPI")
	return
}

// CreateCreateInstanceAccountResponse creates a response to parse from CreateInstanceAccount response
func CreateCreateInstanceAccountResponse() (response *CreateInstanceAccountResponse) {
	response = &CreateInstanceAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
