package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstanceInternetAddress invokes the drds.CreateInstanceInternetAddress API synchronously
// api document: https://help.aliyun.com/api/drds/createinstanceinternetaddress.html
func (client *Client) CreateInstanceInternetAddress(request *CreateInstanceInternetAddressRequest) (response *CreateInstanceInternetAddressResponse, err error) {
	response = CreateCreateInstanceInternetAddressResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstanceInternetAddressWithChan invokes the drds.CreateInstanceInternetAddress API asynchronously
// api document: https://help.aliyun.com/api/drds/createinstanceinternetaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceInternetAddressWithChan(request *CreateInstanceInternetAddressRequest) (<-chan *CreateInstanceInternetAddressResponse, <-chan error) {
	responseChan := make(chan *CreateInstanceInternetAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstanceInternetAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstanceInternetAddressWithCallback invokes the drds.CreateInstanceInternetAddress API asynchronously
// api document: https://help.aliyun.com/api/drds/createinstanceinternetaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceInternetAddressWithCallback(request *CreateInstanceInternetAddressRequest, callback func(response *CreateInstanceInternetAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstanceInternetAddressResponse
		var err error
		defer close(result)
		response, err = client.CreateInstanceInternetAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstanceInternetAddressRequest is the request struct for api CreateInstanceInternetAddress
type CreateInstanceInternetAddressRequest struct {
	*requests.RpcRequest
	DrdsPassword   string `position:"Query" name:"DrdsPassword"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// CreateInstanceInternetAddressResponse is the response struct for api CreateInstanceInternetAddress
type CreateInstanceInternetAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateCreateInstanceInternetAddressRequest creates a request to invoke CreateInstanceInternetAddress API
func CreateCreateInstanceInternetAddressRequest() (request *CreateInstanceInternetAddressRequest) {
	request = &CreateInstanceInternetAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "CreateInstanceInternetAddress", "Drds", "openAPI")
	return
}

// CreateCreateInstanceInternetAddressResponse creates a response to parse from CreateInstanceInternetAddress response
func CreateCreateInstanceInternetAddressResponse() (response *CreateInstanceInternetAddressResponse) {
	response = &CreateInstanceInternetAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
