package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteShardTasks invokes the drds.DeleteShardTasks API synchronously
// api document: https://help.aliyun.com/api/drds/deleteshardtasks.html
func (client *Client) DeleteShardTasks(request *DeleteShardTasksRequest) (response *DeleteShardTasksResponse, err error) {
	response = CreateDeleteShardTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteShardTasksWithChan invokes the drds.DeleteShardTasks API asynchronously
// api document: https://help.aliyun.com/api/drds/deleteshardtasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteShardTasksWithChan(request *DeleteShardTasksRequest) (<-chan *DeleteShardTasksResponse, <-chan error) {
	responseChan := make(chan *DeleteShardTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteShardTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteShardTasksWithCallback invokes the drds.DeleteShardTasks API asynchronously
// api document: https://help.aliyun.com/api/drds/deleteshardtasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteShardTasksWithCallback(request *DeleteShardTasksRequest, callback func(response *DeleteShardTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteShardTasksResponse
		var err error
		defer close(result)
		response, err = client.DeleteShardTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteShardTasksRequest is the request struct for api DeleteShardTasks
type DeleteShardTasksRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string                       `position:"Query" name:"DrdsInstanceId"`
	DbName         string                       `position:"Query" name:"DbName"`
	TableName      *[]DeleteShardTasksTableName `position:"Query" name:"TableName"  type:"Repeated"`
}

// DeleteShardTasksTableName is a repeated param struct in DeleteShardTasksRequest
type DeleteShardTasksTableName struct {
	SourceTableName string `name:"SourceTableName"`
	TargetTableName string `name:"TargetTableName"`
}

// DeleteShardTasksResponse is the response struct for api DeleteShardTasks
type DeleteShardTasksResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteShardTasksRequest creates a request to invoke DeleteShardTasks API
func CreateDeleteShardTasksRequest() (request *DeleteShardTasksRequest) {
	request = &DeleteShardTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DeleteShardTasks", "Drds", "openAPI")
	return
}

// CreateDeleteShardTasksResponse creates a response to parse from DeleteShardTasks response
func CreateDeleteShardTasksResponse() (response *DeleteShardTasksResponse) {
	response = &DeleteShardTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
