package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRdsSuperAccountInstances invokes the drds.DescribeRdsSuperAccountInstances API synchronously
// api document: https://help.aliyun.com/api/drds/describerdssuperaccountinstances.html
func (client *Client) DescribeRdsSuperAccountInstances(request *DescribeRdsSuperAccountInstancesRequest) (response *DescribeRdsSuperAccountInstancesResponse, err error) {
	response = CreateDescribeRdsSuperAccountInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRdsSuperAccountInstancesWithChan invokes the drds.DescribeRdsSuperAccountInstances API asynchronously
// api document: https://help.aliyun.com/api/drds/describerdssuperaccountinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRdsSuperAccountInstancesWithChan(request *DescribeRdsSuperAccountInstancesRequest) (<-chan *DescribeRdsSuperAccountInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeRdsSuperAccountInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRdsSuperAccountInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRdsSuperAccountInstancesWithCallback invokes the drds.DescribeRdsSuperAccountInstances API asynchronously
// api document: https://help.aliyun.com/api/drds/describerdssuperaccountinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRdsSuperAccountInstancesWithCallback(request *DescribeRdsSuperAccountInstancesRequest, callback func(response *DescribeRdsSuperAccountInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRdsSuperAccountInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeRdsSuperAccountInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRdsSuperAccountInstancesRequest is the request struct for api DescribeRdsSuperAccountInstances
type DescribeRdsSuperAccountInstancesRequest struct {
	*requests.RpcRequest
	RdsInstance    *[]string `position:"Query" name:"RdsInstance"  type:"Repeated"`
	DrdsInstanceId string    `position:"Query" name:"DrdsInstanceId"`
	DbInstType     string    `position:"Query" name:"DbInstType"`
}

// DescribeRdsSuperAccountInstancesResponse is the response struct for api DescribeRdsSuperAccountInstances
type DescribeRdsSuperAccountInstancesResponse struct {
	*responses.BaseResponse
	RequestId   string                                        `json:"RequestId" xml:"RequestId"`
	DbInstances DbInstancesInDescribeRdsSuperAccountInstances `json:"DbInstances" xml:"DbInstances"`
}

// CreateDescribeRdsSuperAccountInstancesRequest creates a request to invoke DescribeRdsSuperAccountInstances API
func CreateDescribeRdsSuperAccountInstancesRequest() (request *DescribeRdsSuperAccountInstancesRequest) {
	request = &DescribeRdsSuperAccountInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeRdsSuperAccountInstances", "Drds", "openAPI")
	return
}

// CreateDescribeRdsSuperAccountInstancesResponse creates a response to parse from DescribeRdsSuperAccountInstances response
func CreateDescribeRdsSuperAccountInstancesResponse() (response *DescribeRdsSuperAccountInstancesResponse) {
	response = &DescribeRdsSuperAccountInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
