package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTable invokes the drds.DescribeTable API synchronously
// api document: https://help.aliyun.com/api/drds/describetable.html
func (client *Client) DescribeTable(request *DescribeTableRequest) (response *DescribeTableResponse, err error) {
	response = CreateDescribeTableResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTableWithChan invokes the drds.DescribeTable API asynchronously
// api document: https://help.aliyun.com/api/drds/describetable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTableWithChan(request *DescribeTableRequest) (<-chan *DescribeTableResponse, <-chan error) {
	responseChan := make(chan *DescribeTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTableWithCallback invokes the drds.DescribeTable API asynchronously
// api document: https://help.aliyun.com/api/drds/describetable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTableWithCallback(request *DescribeTableRequest, callback func(response *DescribeTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTableResponse
		var err error
		defer close(result)
		response, err = client.DescribeTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTableRequest is the request struct for api DescribeTable
type DescribeTableRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
	TableName      string `position:"Query" name:"TableName"`
}

// DescribeTableResponse is the response struct for api DescribeTable
type DescribeTableResponse struct {
	*responses.BaseResponse
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Success   bool                `json:"Success" xml:"Success"`
	Data      DataInDescribeTable `json:"Data" xml:"Data"`
}

// CreateDescribeTableRequest creates a request to invoke DescribeTable API
func CreateDescribeTableRequest() (request *DescribeTableRequest) {
	request = &DescribeTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeTable", "Drds", "openAPI")
	return
}

// CreateDescribeTableResponse creates a response to parse from DescribeTable response
func CreateDescribeTableResponse() (response *DescribeTableResponse) {
	response = &DescribeTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
