package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableSqlFlashbackMatchSwitch invokes the drds.EnableSqlFlashbackMatchSwitch API synchronously
// api document: https://help.aliyun.com/api/drds/enablesqlflashbackmatchswitch.html
func (client *Client) EnableSqlFlashbackMatchSwitch(request *EnableSqlFlashbackMatchSwitchRequest) (response *EnableSqlFlashbackMatchSwitchResponse, err error) {
	response = CreateEnableSqlFlashbackMatchSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// EnableSqlFlashbackMatchSwitchWithChan invokes the drds.EnableSqlFlashbackMatchSwitch API asynchronously
// api document: https://help.aliyun.com/api/drds/enablesqlflashbackmatchswitch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableSqlFlashbackMatchSwitchWithChan(request *EnableSqlFlashbackMatchSwitchRequest) (<-chan *EnableSqlFlashbackMatchSwitchResponse, <-chan error) {
	responseChan := make(chan *EnableSqlFlashbackMatchSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableSqlFlashbackMatchSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableSqlFlashbackMatchSwitchWithCallback invokes the drds.EnableSqlFlashbackMatchSwitch API asynchronously
// api document: https://help.aliyun.com/api/drds/enablesqlflashbackmatchswitch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableSqlFlashbackMatchSwitchWithCallback(request *EnableSqlFlashbackMatchSwitchRequest, callback func(response *EnableSqlFlashbackMatchSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableSqlFlashbackMatchSwitchResponse
		var err error
		defer close(result)
		response, err = client.EnableSqlFlashbackMatchSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableSqlFlashbackMatchSwitchRequest is the request struct for api EnableSqlFlashbackMatchSwitch
type EnableSqlFlashbackMatchSwitchRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
}

// EnableSqlFlashbackMatchSwitchResponse is the response struct for api EnableSqlFlashbackMatchSwitch
type EnableSqlFlashbackMatchSwitchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateEnableSqlFlashbackMatchSwitchRequest creates a request to invoke EnableSqlFlashbackMatchSwitch API
func CreateEnableSqlFlashbackMatchSwitchRequest() (request *EnableSqlFlashbackMatchSwitchRequest) {
	request = &EnableSqlFlashbackMatchSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "EnableSqlFlashbackMatchSwitch", "Drds", "openAPI")
	return
}

// CreateEnableSqlFlashbackMatchSwitchResponse creates a response to parse from EnableSqlFlashbackMatchSwitch response
func CreateEnableSqlFlashbackMatchSwitchResponse() (response *EnableSqlFlashbackMatchSwitchResponse) {
	response = &EnableSqlFlashbackMatchSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
