package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetBackupPolicy invokes the drds.SetBackupPolicy API synchronously
// api document: https://help.aliyun.com/api/drds/setbackuppolicy.html
func (client *Client) SetBackupPolicy(request *SetBackupPolicyRequest) (response *SetBackupPolicyResponse, err error) {
	response = CreateSetBackupPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// SetBackupPolicyWithChan invokes the drds.SetBackupPolicy API asynchronously
// api document: https://help.aliyun.com/api/drds/setbackuppolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetBackupPolicyWithChan(request *SetBackupPolicyRequest) (<-chan *SetBackupPolicyResponse, <-chan error) {
	responseChan := make(chan *SetBackupPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetBackupPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetBackupPolicyWithCallback invokes the drds.SetBackupPolicy API asynchronously
// api document: https://help.aliyun.com/api/drds/setbackuppolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetBackupPolicyWithCallback(request *SetBackupPolicyRequest, callback func(response *SetBackupPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetBackupPolicyResponse
		var err error
		defer close(result)
		response, err = client.SetBackupPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetBackupPolicyRequest is the request struct for api SetBackupPolicy
type SetBackupPolicyRequest struct {
	*requests.RpcRequest
	BackupDbNames             string `position:"Query" name:"BackupDbNames"`
	BackupLog                 string `position:"Query" name:"BackupLog"`
	PreferredBackupEndTime    string `position:"Query" name:"PreferredBackupEndTime"`
	PreferredBackupPeriod     string `position:"Query" name:"PreferredBackupPeriod"`
	PreferredBackupStartTime  string `position:"Query" name:"PreferredBackupStartTime"`
	BackupLevel               string `position:"Query" name:"BackupLevel"`
	DrdsInstanceId            string `position:"Query" name:"DrdsInstanceId"`
	DataBackupRetentionPeriod string `position:"Query" name:"DataBackupRetentionPeriod"`
	BackupMode                string `position:"Query" name:"BackupMode"`
	LogBackupRetentionPeriod  string `position:"Query" name:"LogBackupRetentionPeriod"`
}

// SetBackupPolicyResponse is the response struct for api SetBackupPolicy
type SetBackupPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSetBackupPolicyRequest creates a request to invoke SetBackupPolicy API
func CreateSetBackupPolicyRequest() (request *SetBackupPolicyRequest) {
	request = &SetBackupPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SetBackupPolicy", "Drds", "openAPI")
	return
}

// CreateSetBackupPolicyResponse creates a response to parse from SetBackupPolicy response
func CreateSetBackupPolicyResponse() (response *SetBackupPolicyResponse) {
	response = &SetBackupPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
