package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitRollbackShardingKeyModify invokes the drds.SubmitRollbackShardingKeyModify API synchronously
// api document: https://help.aliyun.com/api/drds/submitrollbackshardingkeymodify.html
func (client *Client) SubmitRollbackShardingKeyModify(request *SubmitRollbackShardingKeyModifyRequest) (response *SubmitRollbackShardingKeyModifyResponse, err error) {
	response = CreateSubmitRollbackShardingKeyModifyResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitRollbackShardingKeyModifyWithChan invokes the drds.SubmitRollbackShardingKeyModify API asynchronously
// api document: https://help.aliyun.com/api/drds/submitrollbackshardingkeymodify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitRollbackShardingKeyModifyWithChan(request *SubmitRollbackShardingKeyModifyRequest) (<-chan *SubmitRollbackShardingKeyModifyResponse, <-chan error) {
	responseChan := make(chan *SubmitRollbackShardingKeyModifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitRollbackShardingKeyModify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitRollbackShardingKeyModifyWithCallback invokes the drds.SubmitRollbackShardingKeyModify API asynchronously
// api document: https://help.aliyun.com/api/drds/submitrollbackshardingkeymodify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitRollbackShardingKeyModifyWithCallback(request *SubmitRollbackShardingKeyModifyRequest, callback func(response *SubmitRollbackShardingKeyModifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitRollbackShardingKeyModifyResponse
		var err error
		defer close(result)
		response, err = client.SubmitRollbackShardingKeyModify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitRollbackShardingKeyModifyRequest is the request struct for api SubmitRollbackShardingKeyModify
type SubmitRollbackShardingKeyModifyRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
	TaskId         string `position:"Query" name:"TaskId"`
}

// SubmitRollbackShardingKeyModifyResponse is the response struct for api SubmitRollbackShardingKeyModify
type SubmitRollbackShardingKeyModifyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateSubmitRollbackShardingKeyModifyRequest creates a request to invoke SubmitRollbackShardingKeyModify API
func CreateSubmitRollbackShardingKeyModifyRequest() (request *SubmitRollbackShardingKeyModifyRequest) {
	request = &SubmitRollbackShardingKeyModifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SubmitRollbackShardingKeyModify", "Drds", "openAPI")
	return
}

// CreateSubmitRollbackShardingKeyModifyResponse creates a response to parse from SubmitRollbackShardingKeyModify response
func CreateSubmitRollbackShardingKeyModifyResponse() (response *SubmitRollbackShardingKeyModifyResponse) {
	response = &SubmitRollbackShardingKeyModifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
