//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigureSubscriptionInstance invokes the dts.ConfigureSubscriptionInstance API synchronously
// api document: https://help.aliyun.com/api/dts/configuresubscriptioninstance.html
func (client *Client) ConfigureSubscriptionInstance(request *ConfigureSubscriptionInstanceRequest) (response *ConfigureSubscriptionInstanceResponse, err error) {
	response = CreateConfigureSubscriptionInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigureSubscriptionInstanceWithChan invokes the dts.ConfigureSubscriptionInstance API asynchronously
// api document: https://help.aliyun.com/api/dts/configuresubscriptioninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigureSubscriptionInstanceWithChan(request *ConfigureSubscriptionInstanceRequest) (<-chan *ConfigureSubscriptionInstanceResponse, <-chan error) {
	responseChan := make(chan *ConfigureSubscriptionInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigureSubscriptionInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigureSubscriptionInstanceWithCallback invokes the dts.ConfigureSubscriptionInstance API asynchronously
// api document: https://help.aliyun.com/api/dts/configuresubscriptioninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigureSubscriptionInstanceWithCallback(request *ConfigureSubscriptionInstanceRequest, callback func(response *ConfigureSubscriptionInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigureSubscriptionInstanceResponse
		var err error
		defer close(result)
		response, err = client.ConfigureSubscriptionInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigureSubscriptionInstanceRequest is the request struct for api ConfigureSubscriptionInstance
type ConfigureSubscriptionInstanceRequest struct {
	*requests.RpcRequest
	SubscriptionInstanceId   string                                            `position:"Query" name:"SubscriptionInstanceId"`
	SubscriptionInstanceName string                                            `position:"Query" name:"SubscriptionInstanceName"`
	SubscriptionObject       string                                            `position:"Query" name:"SubscriptionObject"`
	OwnerId                  string                                            `position:"Query" name:"OwnerId"`
	SourceEndpoint           ConfigureSubscriptionInstanceSourceEndpoint       `position:"Query" name:"SourceEndpoint" type:"Struct"`
	SubscriptionDataType     ConfigureSubscriptionInstanceSubscriptionDataType `position:"Query" name:"SubscriptionDataType" type:"Struct"`
}

type ConfigureSubscriptionInstanceSourceEndpoint struct {
	InstanceType string `name:"InstanceType"`
	InstanceID   string `name:"InstanceID"`
	UserName     string `name:"UserName"`
	Password     string `name:"Password"`
	OwnerID      string `name:"OwnerID"`
	Role         string `name:"Role"`
}

type ConfigureSubscriptionInstanceSubscriptionDataType struct {
	DDL requests.Boolean `name:"DDL"`
	DML requests.Boolean `name:"DML"`
}

// ConfigureSubscriptionInstanceResponse is the response struct for api ConfigureSubscriptionInstance
type ConfigureSubscriptionInstanceResponse struct {
	*responses.BaseResponse
	Success    string `json:"Success" xml:"Success"`
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigureSubscriptionInstanceRequest creates a request to invoke ConfigureSubscriptionInstance API
func CreateConfigureSubscriptionInstanceRequest() (request *ConfigureSubscriptionInstanceRequest) {
	request = &ConfigureSubscriptionInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "ConfigureSubscriptionInstance", "dts", "openAPI")
	return
}

// CreateConfigureSubscriptionInstanceResponse creates a response to parse from ConfigureSubscriptionInstance response
func CreateConfigureSubscriptionInstanceResponse() (response *ConfigureSubscriptionInstanceResponse) {
	response = &ConfigureSubscriptionInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
