package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindSubscription invokes the dyplsapi.UnbindSubscription API synchronously
// api document: https://help.aliyun.com/api/dyplsapi/unbindsubscription.html
func (client *Client) UnbindSubscription(request *UnbindSubscriptionRequest) (response *UnbindSubscriptionResponse, err error) {
	response = CreateUnbindSubscriptionResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindSubscriptionWithChan invokes the dyplsapi.UnbindSubscription API asynchronously
// api document: https://help.aliyun.com/api/dyplsapi/unbindsubscription.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindSubscriptionWithChan(request *UnbindSubscriptionRequest) (<-chan *UnbindSubscriptionResponse, <-chan error) {
	responseChan := make(chan *UnbindSubscriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindSubscription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindSubscriptionWithCallback invokes the dyplsapi.UnbindSubscription API asynchronously
// api document: https://help.aliyun.com/api/dyplsapi/unbindsubscription.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindSubscriptionWithCallback(request *UnbindSubscriptionRequest, callback func(response *UnbindSubscriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindSubscriptionResponse
		var err error
		defer close(result)
		response, err = client.UnbindSubscription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindSubscriptionRequest is the request struct for api UnbindSubscription
type UnbindSubscriptionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ProductType          string           `position:"Query" name:"ProductType"`
	SubsId               string           `position:"Query" name:"SubsId"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
}

// UnbindSubscriptionResponse is the response struct for api UnbindSubscription
type UnbindSubscriptionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ChargeId  string `json:"ChargeId" xml:"ChargeId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUnbindSubscriptionRequest creates a request to invoke UnbindSubscription API
func CreateUnbindSubscriptionRequest() (request *UnbindSubscriptionRequest) {
	request = &UnbindSubscriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "UnbindSubscription", "dypls", "openAPI")
	return
}

// CreateUnbindSubscriptionResponse creates a response to parse from UnbindSubscription response
func CreateUnbindSubscriptionResponse() (response *UnbindSubscriptionResponse) {
	response = &UnbindSubscriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
