package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRtcToken invokes the dyvmsapi.GetRtcToken API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/getrtctoken.html
func (client *Client) GetRtcToken(request *GetRtcTokenRequest) (response *GetRtcTokenResponse, err error) {
	response = CreateGetRtcTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GetRtcTokenWithChan invokes the dyvmsapi.GetRtcToken API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/getrtctoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRtcTokenWithChan(request *GetRtcTokenRequest) (<-chan *GetRtcTokenResponse, <-chan error) {
	responseChan := make(chan *GetRtcTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRtcToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRtcTokenWithCallback invokes the dyvmsapi.GetRtcToken API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/getrtctoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRtcTokenWithCallback(request *GetRtcTokenRequest, callback func(response *GetRtcTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRtcTokenResponse
		var err error
		defer close(result)
		response, err = client.GetRtcToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRtcTokenRequest is the request struct for api GetRtcToken
type GetRtcTokenRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UserId               string           `position:"Query" name:"UserId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId             string           `position:"Query" name:"DeviceId"`
	IsCustomAccount      requests.Boolean `position:"Query" name:"IsCustomAccount"`
}

// GetRtcTokenResponse is the response struct for api GetRtcToken
type GetRtcTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    string `json:"Module" xml:"Module"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateGetRtcTokenRequest creates a request to invoke GetRtcToken API
func CreateGetRtcTokenRequest() (request *GetRtcTokenRequest) {
	request = &GetRtcTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "GetRtcToken", "dyvms", "openAPI")
	return
}

// CreateGetRtcTokenResponse creates a response to parse from GetRtcToken response
func CreateGetRtcTokenResponse() (response *GetRtcTokenResponse) {
	response = &GetRtcTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
