package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLogstash invokes the elasticsearch.UpdateLogstash API synchronously
// api document: https://help.aliyun.com/api/elasticsearch/updatelogstash.html
func (client *Client) UpdateLogstash(request *UpdateLogstashRequest) (response *UpdateLogstashResponse, err error) {
	response = CreateUpdateLogstashResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLogstashWithChan invokes the elasticsearch.UpdateLogstash API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/updatelogstash.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateLogstashWithChan(request *UpdateLogstashRequest) (<-chan *UpdateLogstashResponse, <-chan error) {
	responseChan := make(chan *UpdateLogstashResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLogstash(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLogstashWithCallback invokes the elasticsearch.UpdateLogstash API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/updatelogstash.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateLogstashWithCallback(request *UpdateLogstashRequest, callback func(response *UpdateLogstashResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLogstashResponse
		var err error
		defer close(result)
		response, err = client.UpdateLogstash(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLogstashRequest is the request struct for api UpdateLogstash
type UpdateLogstashRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
}

// UpdateLogstashResponse is the response struct for api UpdateLogstash
type UpdateLogstashResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateUpdateLogstashRequest creates a request to invoke UpdateLogstash API
func CreateUpdateLogstashRequest() (request *UpdateLogstashRequest) {
	request = &UpdateLogstashRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateLogstash", "/openapi/logstashes/[InstanceId]", "elasticsearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateLogstashResponse creates a response to parse from UpdateLogstash response
func CreateUpdateLogstashResponse() (response *UpdateLogstashResponse) {
	response = &UpdateLogstashResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
