package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddHpHost invokes the emr.AddHpHost API synchronously
// api document: https://help.aliyun.com/api/emr/addhphost.html
func (client *Client) AddHpHost(request *AddHpHostRequest) (response *AddHpHostResponse, err error) {
	response = CreateAddHpHostResponse()
	err = client.DoAction(request, response)
	return
}

// AddHpHostWithChan invokes the emr.AddHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/addhphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddHpHostWithChan(request *AddHpHostRequest) (<-chan *AddHpHostResponse, <-chan error) {
	responseChan := make(chan *AddHpHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddHpHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddHpHostWithCallback invokes the emr.AddHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/addhphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddHpHostWithCallback(request *AddHpHostRequest, callback func(response *AddHpHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddHpHostResponse
		var err error
		defer close(result)
		response, err = client.AddHpHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddHpHostRequest is the request struct for api AddHpHost
type AddHpHostRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer   `position:"Query" name:"ResourceOwnerId"`
	HpHost          *[]AddHpHostHpHost `position:"Query" name:"HpHost"  type:"Repeated"`
	HpBizId         string             `position:"Query" name:"HpBizId"`
}

// AddHpHostHpHost is a repeated param struct in AddHpHostRequest
type AddHpHostHpHost struct {
	CpuCore         string                 `name:"CpuCore"`
	MemSize         string                 `name:"MemSize"`
	RackInfo        string                 `name:"RackInfo"`
	Role            string                 `name:"Role"`
	SerialNumber    string                 `name:"SerialNumber"`
	HostType        string                 `name:"HostType"`
	SecurityGroupId string                 `name:"SecurityGroupId"`
	HpHostDisk      *[]AddHpHostHpHostDisk `name:"HpHostDisk" type:"Repeated"`
	VswitchId       string                 `name:"VswitchId"`
	ExternalKey     string                 `name:"ExternalKey"`
	HostName        string                 `name:"HostName"`
	VpcId           string                 `name:"VpcId"`
	InnerIp         string                 `name:"InnerIp"`
	ExternalIp      string                 `name:"ExternalIp"`
}

// AddHpHostHpHostDisk is a repeated param struct in AddHpHostRequest
type AddHpHostHpHostDisk struct {
	DiskSize   string `name:"DiskSize"`
	MountPath  string `name:"MountPath"`
	DiskDevice string `name:"DiskDevice"`
}

// AddHpHostResponse is the response struct for api AddHpHost
type AddHpHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	BizId     string `json:"BizId" xml:"BizId"`
}

// CreateAddHpHostRequest creates a request to invoke AddHpHost API
func CreateAddHpHostRequest() (request *AddHpHostRequest) {
	request = &AddHpHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "AddHpHost", "emr", "openAPI")
	return
}

// CreateAddHpHostResponse creates a response to parse from AddHpHost response
func CreateAddHpHostResponse() (response *AddHpHostResponse) {
	response = &AddHpHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
