package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneETLJob invokes the emr.CloneETLJob API synchronously
// api document: https://help.aliyun.com/api/emr/cloneetljob.html
func (client *Client) CloneETLJob(request *CloneETLJobRequest) (response *CloneETLJobResponse, err error) {
	response = CreateCloneETLJobResponse()
	err = client.DoAction(request, response)
	return
}

// CloneETLJobWithChan invokes the emr.CloneETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/cloneetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloneETLJobWithChan(request *CloneETLJobRequest) (<-chan *CloneETLJobResponse, <-chan error) {
	responseChan := make(chan *CloneETLJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneETLJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneETLJobWithCallback invokes the emr.CloneETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/cloneetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloneETLJobWithCallback(request *CloneETLJobRequest, callback func(response *CloneETLJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneETLJobResponse
		var err error
		defer close(result)
		response, err = client.CloneETLJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneETLJobRequest is the request struct for api CloneETLJob
type CloneETLJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Name            string           `position:"Query" name:"Name"`
	Id              string           `position:"Query" name:"Id"`
}

// CloneETLJobResponse is the response struct for api CloneETLJob
type CloneETLJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCloneETLJobRequest creates a request to invoke CloneETLJob API
func CreateCloneETLJobRequest() (request *CloneETLJobRequest) {
	request = &CloneETLJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CloneETLJob", "emr", "openAPI")
	return
}

// CreateCloneETLJobResponse creates a response to parse from CloneETLJob response
func CreateCloneETLJobResponse() (response *CloneETLJobResponse) {
	response = &CloneETLJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
