package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceUser invokes the emr.DeleteResourceUser API synchronously
// api document: https://help.aliyun.com/api/emr/deleteresourceuser.html
func (client *Client) DeleteResourceUser(request *DeleteResourceUserRequest) (response *DeleteResourceUserResponse, err error) {
	response = CreateDeleteResourceUserResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceUserWithChan invokes the emr.DeleteResourceUser API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteresourceuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteResourceUserWithChan(request *DeleteResourceUserRequest) (<-chan *DeleteResourceUserResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceUserWithCallback invokes the emr.DeleteResourceUser API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteresourceuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteResourceUserWithCallback(request *DeleteResourceUserRequest, callback func(response *DeleteResourceUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceUserResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceUserRequest is the request struct for api DeleteResourceUser
type DeleteResourceUserRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	AliyunUserId    string           `position:"Query" name:"AliyunUserId"`
}

// DeleteResourceUserResponse is the response struct for api DeleteResourceUser
type DeleteResourceUserResponse struct {
	*responses.BaseResponse
	Paging    bool   `json:"Paging" xml:"Paging"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteResourceUserRequest creates a request to invoke DeleteResourceUser API
func CreateDeleteResourceUserRequest() (request *DeleteResourceUserRequest) {
	request = &DeleteResourceUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteResourceUser", "emr", "openAPI")
	return
}

// CreateDeleteResourceUserResponse creates a response to parse from DeleteResourceUser response
func CreateDeleteResourceUserResponse() (response *DeleteResourceUserResponse) {
	response = &DeleteResourceUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
