package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHpHost invokes the emr.DescribeHpHost API synchronously
// api document: https://help.aliyun.com/api/emr/describehphost.html
func (client *Client) DescribeHpHost(request *DescribeHpHostRequest) (response *DescribeHpHostResponse, err error) {
	response = CreateDescribeHpHostResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHpHostWithChan invokes the emr.DescribeHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/describehphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHpHostWithChan(request *DescribeHpHostRequest) (<-chan *DescribeHpHostResponse, <-chan error) {
	responseChan := make(chan *DescribeHpHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHpHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHpHostWithCallback invokes the emr.DescribeHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/describehphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHpHostWithCallback(request *DescribeHpHostRequest, callback func(response *DescribeHpHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHpHostResponse
		var err error
		defer close(result)
		response, err = client.DescribeHpHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHpHostRequest is the request struct for api DescribeHpHost
type DescribeHpHostRequest struct {
	*requests.RpcRequest
	HpHostBizId     string           `position:"Query" name:"HpHostBizId"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// DescribeHpHostResponse is the response struct for api DescribeHpHost
type DescribeHpHostResponse struct {
	*responses.BaseResponse
	RequestId           string                              `json:"RequestId" xml:"RequestId"`
	BizId               string                              `json:"BizId" xml:"BizId"`
	HostName            string                              `json:"HostName" xml:"HostName"`
	InnerIp             string                              `json:"InnerIp" xml:"InnerIp"`
	Role                string                              `json:"Role" xml:"Role"`
	Status              string                              `json:"Status" xml:"Status"`
	CpuCore             int                                 `json:"CpuCore" xml:"CpuCore"`
	MemSize             int                                 `json:"MemSize" xml:"MemSize"`
	VpcId               string                              `json:"VpcId" xml:"VpcId"`
	VswitchId           string                              `json:"VswitchId" xml:"VswitchId"`
	SecurityGroupId     string                              `json:"SecurityGroupId" xml:"SecurityGroupId"`
	ExternalIp          string                              `json:"ExternalIp" xml:"ExternalIp"`
	ExternalKey         string                              `json:"ExternalKey" xml:"ExternalKey"`
	InstalledComponents InstalledComponentsInDescribeHpHost `json:"InstalledComponents" xml:"InstalledComponents"`
	DiskList            DiskListInDescribeHpHost            `json:"DiskList" xml:"DiskList"`
}

// CreateDescribeHpHostRequest creates a request to invoke DescribeHpHost API
func CreateDescribeHpHostRequest() (request *DescribeHpHostRequest) {
	request = &DescribeHpHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeHpHost", "emr", "openAPI")
	return
}

// CreateDescribeHpHostResponse creates a response to parse from DescribeHpHost response
func CreateDescribeHpHostResponse() (response *DescribeHpHostResponse) {
	response = &DescribeHpHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
