package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBackupInfo invokes the emr.GetBackupInfo API synchronously
// api document: https://help.aliyun.com/api/emr/getbackupinfo.html
func (client *Client) GetBackupInfo(request *GetBackupInfoRequest) (response *GetBackupInfoResponse, err error) {
	response = CreateGetBackupInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetBackupInfoWithChan invokes the emr.GetBackupInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getbackupinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBackupInfoWithChan(request *GetBackupInfoRequest) (<-chan *GetBackupInfoResponse, <-chan error) {
	responseChan := make(chan *GetBackupInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBackupInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBackupInfoWithCallback invokes the emr.GetBackupInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getbackupinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBackupInfoWithCallback(request *GetBackupInfoRequest, callback func(response *GetBackupInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBackupInfoResponse
		var err error
		defer close(result)
		response, err = client.GetBackupInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBackupInfoRequest is the request struct for api GetBackupInfo
type GetBackupInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BackupId        string           `position:"Query" name:"BackupId"`
}

// GetBackupInfoResponse is the response struct for api GetBackupInfo
type GetBackupInfoResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Id           string       `json:"Id" xml:"Id"`
	BackupPlanId string       `json:"BackupPlanId" xml:"BackupPlanId"`
	ClusterId    string       `json:"ClusterId" xml:"ClusterId"`
	CreateTime   int64        `json:"CreateTime" xml:"CreateTime"`
	Md5          string       `json:"Md5" xml:"Md5"`
	TarFileName  string       `json:"TarFileName" xml:"TarFileName"`
	StorePath    string       `json:"StorePath" xml:"StorePath"`
	Status       string       `json:"Status" xml:"Status"`
	MetadataInfo MetadataInfo `json:"MetadataInfo" xml:"MetadataInfo"`
}

// CreateGetBackupInfoRequest creates a request to invoke GetBackupInfo API
func CreateGetBackupInfoRequest() (request *GetBackupInfoRequest) {
	request = &GetBackupInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetBackupInfo", "emr", "openAPI")
	return
}

// CreateGetBackupInfoResponse creates a response to parse from GetBackupInfo response
func CreateGetBackupInfoResponse() (response *GetBackupInfoResponse) {
	response = &GetBackupInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
