package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFlowAuditLogs invokes the emr.GetFlowAuditLogs API synchronously
// api document: https://help.aliyun.com/api/emr/getflowauditlogs.html
func (client *Client) GetFlowAuditLogs(request *GetFlowAuditLogsRequest) (response *GetFlowAuditLogsResponse, err error) {
	response = CreateGetFlowAuditLogsResponse()
	err = client.DoAction(request, response)
	return
}

// GetFlowAuditLogsWithChan invokes the emr.GetFlowAuditLogs API asynchronously
// api document: https://help.aliyun.com/api/emr/getflowauditlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetFlowAuditLogsWithChan(request *GetFlowAuditLogsRequest) (<-chan *GetFlowAuditLogsResponse, <-chan error) {
	responseChan := make(chan *GetFlowAuditLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFlowAuditLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFlowAuditLogsWithCallback invokes the emr.GetFlowAuditLogs API asynchronously
// api document: https://help.aliyun.com/api/emr/getflowauditlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetFlowAuditLogsWithCallback(request *GetFlowAuditLogsRequest, callback func(response *GetFlowAuditLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFlowAuditLogsResponse
		var err error
		defer close(result)
		response, err = client.GetFlowAuditLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFlowAuditLogsRequest is the request struct for api GetFlowAuditLogs
type GetFlowAuditLogsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageCount       requests.Integer `position:"Query" name:"PageCount"`
	OrderMode       string           `position:"Query" name:"OrderMode"`
	EntityId        string           `position:"Query" name:"EntityId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	Limit           requests.Integer `position:"Query" name:"Limit"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
	OrderField      string           `position:"Query" name:"OrderField"`
	EntityGroupId   string           `position:"Query" name:"EntityGroupId"`
	EntityType      string           `position:"Query" name:"EntityType"`
	OperatorId      string           `position:"Query" name:"OperatorId"`
	Operation       string           `position:"Query" name:"Operation"`
	Status          string           `position:"Query" name:"Status"`
}

// GetFlowAuditLogsResponse is the response struct for api GetFlowAuditLogs
type GetFlowAuditLogsResponse struct {
	*responses.BaseResponse
	RequestId  string                  `json:"RequestId" xml:"RequestId"`
	PageNumber int                     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                     `json:"PageSize" xml:"PageSize"`
	TotalCount int                     `json:"TotalCount" xml:"TotalCount"`
	Items      ItemsInGetFlowAuditLogs `json:"Items" xml:"Items"`
}

// CreateGetFlowAuditLogsRequest creates a request to invoke GetFlowAuditLogs API
func CreateGetFlowAuditLogsRequest() (request *GetFlowAuditLogsRequest) {
	request = &GetFlowAuditLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetFlowAuditLogs", "emr", "openAPI")
	return
}

// CreateGetFlowAuditLogsResponse creates a response to parse from GetFlowAuditLogs response
func CreateGetFlowAuditLogsResponse() (response *GetFlowAuditLogsResponse) {
	response = &GetFlowAuditLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
