package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApmApplication invokes the emr.ListApmApplication API synchronously
// api document: https://help.aliyun.com/api/emr/listapmapplication.html
func (client *Client) ListApmApplication(request *ListApmApplicationRequest) (response *ListApmApplicationResponse, err error) {
	response = CreateListApmApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// ListApmApplicationWithChan invokes the emr.ListApmApplication API asynchronously
// api document: https://help.aliyun.com/api/emr/listapmapplication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApmApplicationWithChan(request *ListApmApplicationRequest) (<-chan *ListApmApplicationResponse, <-chan error) {
	responseChan := make(chan *ListApmApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApmApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApmApplicationWithCallback invokes the emr.ListApmApplication API asynchronously
// api document: https://help.aliyun.com/api/emr/listapmapplication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApmApplicationWithCallback(request *ListApmApplicationRequest, callback func(response *ListApmApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApmApplicationResponse
		var err error
		defer close(result)
		response, err = client.ListApmApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApmApplicationRequest is the request struct for api ListApmApplication
type ListApmApplicationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DiagnoseResult  string           `position:"Query" name:"DiagnoseResult"`
	EndTimeFrom     requests.Integer `position:"Query" name:"EndTimeFrom"`
	OrderBy         string           `position:"Query" name:"OrderBy"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	JobType         string           `position:"Query" name:"JobType"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	FinalStatus     string           `position:"Query" name:"FinalStatus"`
	StartTimeFrom   requests.Integer `position:"Query" name:"StartTimeFrom"`
	AppId           string           `position:"Query" name:"AppId"`
	Name            string           `position:"Query" name:"Name"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	State           string           `position:"Query" name:"State"`
	StartTimeTo     requests.Integer `position:"Query" name:"StartTimeTo"`
	User            string           `position:"Query" name:"User"`
	EndTimeTo       requests.Integer `position:"Query" name:"EndTimeTo"`
	Queue           string           `position:"Query" name:"Queue"`
}

// ListApmApplicationResponse is the response struct for api ListApmApplication
type ListApmApplicationResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Total          int            `json:"Total" xml:"Total"`
	PageSize       int            `json:"PageSize" xml:"PageSize"`
	PageNumber     int            `json:"PageNumber" xml:"PageNumber"`
	ApmAppInfoList ApmAppInfoList `json:"ApmAppInfoList" xml:"ApmAppInfoList"`
}

// CreateListApmApplicationRequest creates a request to invoke ListApmApplication API
func CreateListApmApplicationRequest() (request *ListApmApplicationRequest) {
	request = &ListApmApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListApmApplication", "emr", "openAPI")
	return
}

// CreateListApmApplicationResponse creates a response to parse from ListApmApplication response
func CreateListApmApplicationResponse() (response *ListApmApplicationResponse) {
	response = &ListApmApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
