package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobExecutionInstanceTrend invokes the emr.ListJobExecutionInstanceTrend API synchronously
// api document: https://help.aliyun.com/api/emr/listjobexecutioninstancetrend.html
func (client *Client) ListJobExecutionInstanceTrend(request *ListJobExecutionInstanceTrendRequest) (response *ListJobExecutionInstanceTrendResponse, err error) {
	response = CreateListJobExecutionInstanceTrendResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobExecutionInstanceTrendWithChan invokes the emr.ListJobExecutionInstanceTrend API asynchronously
// api document: https://help.aliyun.com/api/emr/listjobexecutioninstancetrend.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobExecutionInstanceTrendWithChan(request *ListJobExecutionInstanceTrendRequest) (<-chan *ListJobExecutionInstanceTrendResponse, <-chan error) {
	responseChan := make(chan *ListJobExecutionInstanceTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobExecutionInstanceTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobExecutionInstanceTrendWithCallback invokes the emr.ListJobExecutionInstanceTrend API asynchronously
// api document: https://help.aliyun.com/api/emr/listjobexecutioninstancetrend.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobExecutionInstanceTrendWithCallback(request *ListJobExecutionInstanceTrendRequest, callback func(response *ListJobExecutionInstanceTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobExecutionInstanceTrendResponse
		var err error
		defer close(result)
		response, err = client.ListJobExecutionInstanceTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobExecutionInstanceTrendRequest is the request struct for api ListJobExecutionInstanceTrend
type ListJobExecutionInstanceTrendRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// ListJobExecutionInstanceTrendResponse is the response struct for api ListJobExecutionInstanceTrend
type ListJobExecutionInstanceTrendResponse struct {
	*responses.BaseResponse
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	Trends    TrendsInListJobExecutionInstanceTrend `json:"Trends" xml:"Trends"`
}

// CreateListJobExecutionInstanceTrendRequest creates a request to invoke ListJobExecutionInstanceTrend API
func CreateListJobExecutionInstanceTrendRequest() (request *ListJobExecutionInstanceTrendRequest) {
	request = &ListJobExecutionInstanceTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListJobExecutionInstanceTrend", "emr", "openAPI")
	return
}

// CreateListJobExecutionInstanceTrendResponse creates a response to parse from ListJobExecutionInstanceTrend response
func CreateListJobExecutionInstanceTrendResponse() (response *ListJobExecutionInstanceTrendResponse) {
	response = &ListJobExecutionInstanceTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
