package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreDescribeDatabase invokes the emr.MetastoreDescribeDatabase API synchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribedatabase.html
func (client *Client) MetastoreDescribeDatabase(request *MetastoreDescribeDatabaseRequest) (response *MetastoreDescribeDatabaseResponse, err error) {
	response = CreateMetastoreDescribeDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreDescribeDatabaseWithChan invokes the emr.MetastoreDescribeDatabase API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribedatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeDatabaseWithChan(request *MetastoreDescribeDatabaseRequest) (<-chan *MetastoreDescribeDatabaseResponse, <-chan error) {
	responseChan := make(chan *MetastoreDescribeDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreDescribeDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreDescribeDatabaseWithCallback invokes the emr.MetastoreDescribeDatabase API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribedatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeDatabaseWithCallback(request *MetastoreDescribeDatabaseRequest, callback func(response *MetastoreDescribeDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreDescribeDatabaseResponse
		var err error
		defer close(result)
		response, err = client.MetastoreDescribeDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreDescribeDatabaseRequest is the request struct for api MetastoreDescribeDatabase
type MetastoreDescribeDatabaseRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	Id              string           `position:"Query" name:"Id"`
}

// MetastoreDescribeDatabaseResponse is the response struct for api MetastoreDescribeDatabase
type MetastoreDescribeDatabaseResponse struct {
	*responses.BaseResponse
	RequestId   string     `json:"RequestId" xml:"RequestId"`
	DbName      string     `json:"DbName" xml:"DbName"`
	Description string     `json:"Description" xml:"Description"`
	LocationUri string     `json:"LocationUri" xml:"LocationUri"`
	Database    Database   `json:"Database" xml:"Database"`
	Parameters  Parameters `json:"Parameters" xml:"Parameters"`
}

// CreateMetastoreDescribeDatabaseRequest creates a request to invoke MetastoreDescribeDatabase API
func CreateMetastoreDescribeDatabaseRequest() (request *MetastoreDescribeDatabaseRequest) {
	request = &MetastoreDescribeDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreDescribeDatabase", "emr", "openAPI")
	return
}

// CreateMetastoreDescribeDatabaseResponse creates a response to parse from MetastoreDescribeDatabase response
func CreateMetastoreDescribeDatabaseResponse() (response *MetastoreDescribeDatabaseResponse) {
	response = &MetastoreDescribeDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
