package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHostPool invokes the emr.ModifyHostPool API synchronously
// api document: https://help.aliyun.com/api/emr/modifyhostpool.html
func (client *Client) ModifyHostPool(request *ModifyHostPoolRequest) (response *ModifyHostPoolResponse, err error) {
	response = CreateModifyHostPoolResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHostPoolWithChan invokes the emr.ModifyHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyhostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyHostPoolWithChan(request *ModifyHostPoolRequest) (<-chan *ModifyHostPoolResponse, <-chan error) {
	responseChan := make(chan *ModifyHostPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHostPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHostPoolWithCallback invokes the emr.ModifyHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyhostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyHostPoolWithCallback(request *ModifyHostPoolRequest, callback func(response *ModifyHostPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHostPoolResponse
		var err error
		defer close(result)
		response, err = client.ModifyHostPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHostPoolRequest is the request struct for api ModifyHostPool
type ModifyHostPoolRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Name            string           `position:"Query" name:"Name"`
	BizId           string           `position:"Query" name:"BizId"`
	Description     string           `position:"Query" name:"Description"`
}

// ModifyHostPoolResponse is the response struct for api ModifyHostPool
type ModifyHostPoolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	BizId     string `json:"BizId" xml:"BizId"`
}

// CreateModifyHostPoolRequest creates a request to invoke ModifyHostPool API
func CreateModifyHostPoolRequest() (request *ModifyHostPoolRequest) {
	request = &ModifyHostPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyHostPool", "emr", "openAPI")
	return
}

// CreateModifyHostPoolResponse creates a response to parse from ModifyHostPool response
func CreateModifyHostPoolResponse() (response *ModifyHostPoolResponse) {
	response = &ModifyHostPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
