package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OfflineKafkaBroker invokes the emr.OfflineKafkaBroker API synchronously
// api document: https://help.aliyun.com/api/emr/offlinekafkabroker.html
func (client *Client) OfflineKafkaBroker(request *OfflineKafkaBrokerRequest) (response *OfflineKafkaBrokerResponse, err error) {
	response = CreateOfflineKafkaBrokerResponse()
	err = client.DoAction(request, response)
	return
}

// OfflineKafkaBrokerWithChan invokes the emr.OfflineKafkaBroker API asynchronously
// api document: https://help.aliyun.com/api/emr/offlinekafkabroker.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OfflineKafkaBrokerWithChan(request *OfflineKafkaBrokerRequest) (<-chan *OfflineKafkaBrokerResponse, <-chan error) {
	responseChan := make(chan *OfflineKafkaBrokerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OfflineKafkaBroker(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OfflineKafkaBrokerWithCallback invokes the emr.OfflineKafkaBroker API asynchronously
// api document: https://help.aliyun.com/api/emr/offlinekafkabroker.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OfflineKafkaBrokerWithCallback(request *OfflineKafkaBrokerRequest, callback func(response *OfflineKafkaBrokerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OfflineKafkaBrokerResponse
		var err error
		defer close(result)
		response, err = client.OfflineKafkaBroker(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OfflineKafkaBrokerRequest is the request struct for api OfflineKafkaBroker
type OfflineKafkaBrokerRequest struct {
	*requests.RpcRequest
	Throttle        requests.Integer `position:"Query" name:"Throttle"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostId          string           `position:"Query" name:"HostId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// OfflineKafkaBrokerResponse is the response struct for api OfflineKafkaBroker
type OfflineKafkaBrokerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOfflineKafkaBrokerRequest creates a request to invoke OfflineKafkaBroker API
func CreateOfflineKafkaBrokerRequest() (request *OfflineKafkaBrokerRequest) {
	request = &OfflineKafkaBrokerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "OfflineKafkaBroker", "emr", "openAPI")
	return
}

// CreateOfflineKafkaBrokerResponse creates a response to parse from OfflineKafkaBroker response
func CreateOfflineKafkaBrokerResponse() (response *OfflineKafkaBrokerResponse) {
	response = &OfflineKafkaBrokerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
