package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUserActionsPolicy invokes the emr.QueryUserActionsPolicy API synchronously
// api document: https://help.aliyun.com/api/emr/queryuseractionspolicy.html
func (client *Client) QueryUserActionsPolicy(request *QueryUserActionsPolicyRequest) (response *QueryUserActionsPolicyResponse, err error) {
	response = CreateQueryUserActionsPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUserActionsPolicyWithChan invokes the emr.QueryUserActionsPolicy API asynchronously
// api document: https://help.aliyun.com/api/emr/queryuseractionspolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryUserActionsPolicyWithChan(request *QueryUserActionsPolicyRequest) (<-chan *QueryUserActionsPolicyResponse, <-chan error) {
	responseChan := make(chan *QueryUserActionsPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUserActionsPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUserActionsPolicyWithCallback invokes the emr.QueryUserActionsPolicy API asynchronously
// api document: https://help.aliyun.com/api/emr/queryuseractionspolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryUserActionsPolicyWithCallback(request *QueryUserActionsPolicyRequest, callback func(response *QueryUserActionsPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUserActionsPolicyResponse
		var err error
		defer close(result)
		response, err = client.QueryUserActionsPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUserActionsPolicyRequest is the request struct for api QueryUserActionsPolicy
type QueryUserActionsPolicyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	ActionNameList  *[]string        `position:"Query" name:"ActionNameList"  type:"Repeated"`
	AliyunUserId    string           `position:"Query" name:"AliyunUserId"`
}

// QueryUserActionsPolicyResponse is the response struct for api QueryUserActionsPolicy
type QueryUserActionsPolicyResponse struct {
	*responses.BaseResponse
	Paging    bool                         `json:"Paging" xml:"Paging"`
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	Data      DataInQueryUserActionsPolicy `json:"Data" xml:"Data"`
}

// CreateQueryUserActionsPolicyRequest creates a request to invoke QueryUserActionsPolicy API
func CreateQueryUserActionsPolicyRequest() (request *QueryUserActionsPolicyRequest) {
	request = &QueryUserActionsPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "QueryUserActionsPolicy", "emr", "openAPI")
	return
}

// CreateQueryUserActionsPolicyResponse creates a response to parse from QueryUserActionsPolicy response
func CreateQueryUserActionsPolicyResponse() (response *QueryUserActionsPolicyResponse) {
	response = &QueryUserActionsPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
