package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReassignKafka invokes the emr.ReassignKafka API synchronously
// api document: https://help.aliyun.com/api/emr/reassignkafka.html
func (client *Client) ReassignKafka(request *ReassignKafkaRequest) (response *ReassignKafkaResponse, err error) {
	response = CreateReassignKafkaResponse()
	err = client.DoAction(request, response)
	return
}

// ReassignKafkaWithChan invokes the emr.ReassignKafka API asynchronously
// api document: https://help.aliyun.com/api/emr/reassignkafka.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReassignKafkaWithChan(request *ReassignKafkaRequest) (<-chan *ReassignKafkaResponse, <-chan error) {
	responseChan := make(chan *ReassignKafkaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReassignKafka(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReassignKafkaWithCallback invokes the emr.ReassignKafka API asynchronously
// api document: https://help.aliyun.com/api/emr/reassignkafka.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReassignKafkaWithCallback(request *ReassignKafkaRequest, callback func(response *ReassignKafkaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReassignKafkaResponse
		var err error
		defer close(result)
		response, err = client.ReassignKafka(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReassignKafkaRequest is the request struct for api ReassignKafka
type ReassignKafkaRequest struct {
	*requests.RpcRequest
	Throttle        requests.Integer `position:"Query" name:"Throttle"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TopicId         string           `position:"Query" name:"TopicId"`
	BrokerId        *[]string        `position:"Query" name:"BrokerId"  type:"Repeated"`
}

// ReassignKafkaResponse is the response struct for api ReassignKafka
type ReassignKafkaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReassignKafkaRequest creates a request to invoke ReassignKafka API
func CreateReassignKafkaRequest() (request *ReassignKafkaRequest) {
	request = &ReassignKafkaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ReassignKafka", "emr", "openAPI")
	return
}

// CreateReassignKafkaResponse creates a response to parse from ReassignKafka response
func CreateReassignKafkaResponse() (response *ReassignKafkaResponse) {
	response = &ReassignKafkaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
