package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunOpsCommand invokes the emr.RunOpsCommand API synchronously
// api document: https://help.aliyun.com/api/emr/runopscommand.html
func (client *Client) RunOpsCommand(request *RunOpsCommandRequest) (response *RunOpsCommandResponse, err error) {
	response = CreateRunOpsCommandResponse()
	err = client.DoAction(request, response)
	return
}

// RunOpsCommandWithChan invokes the emr.RunOpsCommand API asynchronously
// api document: https://help.aliyun.com/api/emr/runopscommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RunOpsCommandWithChan(request *RunOpsCommandRequest) (<-chan *RunOpsCommandResponse, <-chan error) {
	responseChan := make(chan *RunOpsCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunOpsCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunOpsCommandWithCallback invokes the emr.RunOpsCommand API asynchronously
// api document: https://help.aliyun.com/api/emr/runopscommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RunOpsCommandWithCallback(request *RunOpsCommandRequest, callback func(response *RunOpsCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunOpsCommandResponse
		var err error
		defer close(result)
		response, err = client.RunOpsCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunOpsCommandRequest is the request struct for api RunOpsCommand
type RunOpsCommandRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OpsCommandName  string           `position:"Query" name:"OpsCommandName"`
	Comment         string           `position:"Query" name:"Comment"`
	CustomParams    string           `position:"Query" name:"CustomParams"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	HostIdList      *[]string        `position:"Query" name:"HostIdList"  type:"Repeated"`
	Dimension       string           `position:"Query" name:"Dimension"`
}

// RunOpsCommandResponse is the response struct for api RunOpsCommand
type RunOpsCommandResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	OperationId int64  `json:"OperationId" xml:"OperationId"`
}

// CreateRunOpsCommandRequest creates a request to invoke RunOpsCommand API
func CreateRunOpsCommandRequest() (request *RunOpsCommandRequest) {
	request = &RunOpsCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RunOpsCommand", "emr", "openAPI")
	return
}

// CreateRunOpsCommandResponse creates a response to parse from RunOpsCommand response
func CreateRunOpsCommandResponse() (response *RunOpsCommandResponse) {
	response = &RunOpsCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
