package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveUserAccountInfo invokes the emr.SaveUserAccountInfo API synchronously
// api document: https://help.aliyun.com/api/emr/saveuseraccountinfo.html
func (client *Client) SaveUserAccountInfo(request *SaveUserAccountInfoRequest) (response *SaveUserAccountInfoResponse, err error) {
	response = CreateSaveUserAccountInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SaveUserAccountInfoWithChan invokes the emr.SaveUserAccountInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/saveuseraccountinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveUserAccountInfoWithChan(request *SaveUserAccountInfoRequest) (<-chan *SaveUserAccountInfoResponse, <-chan error) {
	responseChan := make(chan *SaveUserAccountInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveUserAccountInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveUserAccountInfoWithCallback invokes the emr.SaveUserAccountInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/saveuseraccountinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveUserAccountInfoWithCallback(request *SaveUserAccountInfoRequest, callback func(response *SaveUserAccountInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveUserAccountInfoResponse
		var err error
		defer close(result)
		response, err = client.SaveUserAccountInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveUserAccountInfoRequest is the request struct for api SaveUserAccountInfo
type SaveUserAccountInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AccountType     string           `position:"Query" name:"AccountType"`
	GroupName       string           `position:"Query" name:"GroupName"`
	AuthType        string           `position:"Query" name:"AuthType"`
	AccountPassword string           `position:"Query" name:"AccountPassword"`
	AliyunUserId    string           `position:"Query" name:"AliyunUserId"`
}

// SaveUserAccountInfoResponse is the response struct for api SaveUserAccountInfo
type SaveUserAccountInfoResponse struct {
	*responses.BaseResponse
	Paging    bool   `json:"Paging" xml:"Paging"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateSaveUserAccountInfoRequest creates a request to invoke SaveUserAccountInfo API
func CreateSaveUserAccountInfoRequest() (request *SaveUserAccountInfoRequest) {
	request = &SaveUserAccountInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "SaveUserAccountInfo", "emr", "openAPI")
	return
}

// CreateSaveUserAccountInfoResponse creates a response to parse from SaveUserAccountInfo response
func CreateSaveUserAccountInfoResponse() (response *SaveUserAccountInfoResponse) {
	response = &SaveUserAccountInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
