package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateKafkaReassignParam invokes the emr.UpdateKafkaReassignParam API synchronously
// api document: https://help.aliyun.com/api/emr/updatekafkareassignparam.html
func (client *Client) UpdateKafkaReassignParam(request *UpdateKafkaReassignParamRequest) (response *UpdateKafkaReassignParamResponse, err error) {
	response = CreateUpdateKafkaReassignParamResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateKafkaReassignParamWithChan invokes the emr.UpdateKafkaReassignParam API asynchronously
// api document: https://help.aliyun.com/api/emr/updatekafkareassignparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateKafkaReassignParamWithChan(request *UpdateKafkaReassignParamRequest) (<-chan *UpdateKafkaReassignParamResponse, <-chan error) {
	responseChan := make(chan *UpdateKafkaReassignParamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateKafkaReassignParam(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateKafkaReassignParamWithCallback invokes the emr.UpdateKafkaReassignParam API asynchronously
// api document: https://help.aliyun.com/api/emr/updatekafkareassignparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateKafkaReassignParamWithCallback(request *UpdateKafkaReassignParamRequest, callback func(response *UpdateKafkaReassignParamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateKafkaReassignParamResponse
		var err error
		defer close(result)
		response, err = client.UpdateKafkaReassignParam(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateKafkaReassignParamRequest is the request struct for api UpdateKafkaReassignParam
type UpdateKafkaReassignParamRequest struct {
	*requests.RpcRequest
	Throttle        requests.Integer `position:"Query" name:"Throttle"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ReassignId      string           `position:"Query" name:"ReassignId"`
}

// UpdateKafkaReassignParamResponse is the response struct for api UpdateKafkaReassignParam
type UpdateKafkaReassignParamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateKafkaReassignParamRequest creates a request to invoke UpdateKafkaReassignParam API
func CreateUpdateKafkaReassignParamRequest() (request *UpdateKafkaReassignParamRequest) {
	request = &UpdateKafkaReassignParamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "UpdateKafkaReassignParam", "emr", "openAPI")
	return
}

// CreateUpdateKafkaReassignParamResponse creates a response to parse from UpdateKafkaReassignParam response
func CreateUpdateKafkaReassignParamResponse() (response *UpdateKafkaReassignParamResponse) {
	response = &UpdateKafkaReassignParamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
