package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClusterMetrics invokes the foas.GetClusterMetrics API synchronously
// api document: https://help.aliyun.com/api/foas/getclustermetrics.html
func (client *Client) GetClusterMetrics(request *GetClusterMetricsRequest) (response *GetClusterMetricsResponse, err error) {
	response = CreateGetClusterMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// GetClusterMetricsWithChan invokes the foas.GetClusterMetrics API asynchronously
// api document: https://help.aliyun.com/api/foas/getclustermetrics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetClusterMetricsWithChan(request *GetClusterMetricsRequest) (<-chan *GetClusterMetricsResponse, <-chan error) {
	responseChan := make(chan *GetClusterMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClusterMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClusterMetricsWithCallback invokes the foas.GetClusterMetrics API asynchronously
// api document: https://help.aliyun.com/api/foas/getclustermetrics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetClusterMetricsWithCallback(request *GetClusterMetricsRequest, callback func(response *GetClusterMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClusterMetricsResponse
		var err error
		defer close(result)
		response, err = client.GetClusterMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClusterMetricsRequest is the request struct for api GetClusterMetrics
type GetClusterMetricsRequest struct {
	*requests.RoaRequest
	ClusterId  string `position:"Path" name:"clusterId"`
	MetricJson string `position:"Body" name:"metricJson"`
}

// GetClusterMetricsResponse is the response struct for api GetClusterMetrics
type GetClusterMetricsResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Metrics   MetricsInGetClusterMetrics `json:"Metrics" xml:"Metrics"`
}

// CreateGetClusterMetricsRequest creates a request to invoke GetClusterMetrics API
func CreateGetClusterMetricsRequest() (request *GetClusterMetricsRequest) {
	request = &GetClusterMetricsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetClusterMetrics", "/api/v2/clusters/[clusterId]/metrics", "foas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetClusterMetricsResponse creates a response to parse from GetClusterMetrics response
func CreateGetClusterMetricsResponse() (response *GetClusterMetricsResponse) {
	response = &GetClusterMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
