package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBizType invokes the green.CreateBizType API synchronously
// api document: https://help.aliyun.com/api/green/createbiztype.html
func (client *Client) CreateBizType(request *CreateBizTypeRequest) (response *CreateBizTypeResponse, err error) {
	response = CreateCreateBizTypeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBizTypeWithChan invokes the green.CreateBizType API asynchronously
// api document: https://help.aliyun.com/api/green/createbiztype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBizTypeWithChan(request *CreateBizTypeRequest) (<-chan *CreateBizTypeResponse, <-chan error) {
	responseChan := make(chan *CreateBizTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBizType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBizTypeWithCallback invokes the green.CreateBizType API asynchronously
// api document: https://help.aliyun.com/api/green/createbiztype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBizTypeWithCallback(request *CreateBizTypeRequest, callback func(response *CreateBizTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBizTypeResponse
		var err error
		defer close(result)
		response, err = client.CreateBizType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBizTypeRequest is the request struct for api CreateBizType
type CreateBizTypeRequest struct {
	*requests.RpcRequest
	BizTypeImport string `position:"Query" name:"BizTypeImport"`
	SourceIp      string `position:"Query" name:"SourceIp"`
	IndustryInfo  string `position:"Query" name:"IndustryInfo"`
	BizTypeName   string `position:"Query" name:"BizTypeName"`
}

// CreateBizTypeResponse is the response struct for api CreateBizType
type CreateBizTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateBizTypeRequest creates a request to invoke CreateBizType API
func CreateCreateBizTypeRequest() (request *CreateBizTypeRequest) {
	request = &CreateBizTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "CreateBizType", "green", "openAPI")
	return
}

// CreateCreateBizTypeResponse creates a response to parse from CreateBizType response
func CreateCreateBizTypeResponse() (response *CreateBizTypeResponse) {
	response = &CreateBizTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
