package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCdiBaseBag invokes the green.CreateCdiBaseBag API synchronously
// api document: https://help.aliyun.com/api/green/createcdibasebag.html
func (client *Client) CreateCdiBaseBag(request *CreateCdiBaseBagRequest) (response *CreateCdiBaseBagResponse, err error) {
	response = CreateCreateCdiBaseBagResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCdiBaseBagWithChan invokes the green.CreateCdiBaseBag API asynchronously
// api document: https://help.aliyun.com/api/green/createcdibasebag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCdiBaseBagWithChan(request *CreateCdiBaseBagRequest) (<-chan *CreateCdiBaseBagResponse, <-chan error) {
	responseChan := make(chan *CreateCdiBaseBagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCdiBaseBag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCdiBaseBagWithCallback invokes the green.CreateCdiBaseBag API asynchronously
// api document: https://help.aliyun.com/api/green/createcdibasebag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCdiBaseBagWithCallback(request *CreateCdiBaseBagRequest, callback func(response *CreateCdiBaseBagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCdiBaseBagResponse
		var err error
		defer close(result)
		response, err = client.CreateCdiBaseBag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCdiBaseBagRequest is the request struct for api CreateCdiBaseBag
type CreateCdiBaseBagRequest struct {
	*requests.RpcRequest
	Duration      requests.Integer `position:"Query" name:"Duration"`
	ClientToken   string           `position:"Query" name:"ClientToken"`
	CommodityCode string           `position:"Query" name:"CommodityCode"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	FlowOutSpec   requests.Integer `position:"Query" name:"FlowOutSpec"`
	OrderType     string           `position:"Query" name:"OrderType"`
}

// CreateCdiBaseBagResponse is the response struct for api CreateCdiBaseBag
type CreateCdiBaseBagResponse struct {
	*responses.BaseResponse
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
	OrderId    string `json:"OrderId" xml:"OrderId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCdiBaseBagRequest creates a request to invoke CreateCdiBaseBag API
func CreateCreateCdiBaseBagRequest() (request *CreateCdiBaseBagRequest) {
	request = &CreateCdiBaseBagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "CreateCdiBaseBag", "green", "openAPI")
	return
}

// CreateCreateCdiBaseBagResponse creates a response to parse from CreateCdiBaseBag response
func CreateCreateCdiBaseBagResponse() (response *CreateCdiBaseBagResponse) {
	response = &CreateCdiBaseBagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
