package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomOcrTemplate invokes the green.DeleteCustomOcrTemplate API synchronously
// api document: https://help.aliyun.com/api/green/deletecustomocrtemplate.html
func (client *Client) DeleteCustomOcrTemplate(request *DeleteCustomOcrTemplateRequest) (response *DeleteCustomOcrTemplateResponse, err error) {
	response = CreateDeleteCustomOcrTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomOcrTemplateWithChan invokes the green.DeleteCustomOcrTemplate API asynchronously
// api document: https://help.aliyun.com/api/green/deletecustomocrtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCustomOcrTemplateWithChan(request *DeleteCustomOcrTemplateRequest) (<-chan *DeleteCustomOcrTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomOcrTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomOcrTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomOcrTemplateWithCallback invokes the green.DeleteCustomOcrTemplate API asynchronously
// api document: https://help.aliyun.com/api/green/deletecustomocrtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCustomOcrTemplateWithCallback(request *DeleteCustomOcrTemplateRequest, callback func(response *DeleteCustomOcrTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomOcrTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomOcrTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomOcrTemplateRequest is the request struct for api DeleteCustomOcrTemplate
type DeleteCustomOcrTemplateRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Ids      string `position:"Query" name:"Ids"`
}

// DeleteCustomOcrTemplateResponse is the response struct for api DeleteCustomOcrTemplate
type DeleteCustomOcrTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCustomOcrTemplateRequest creates a request to invoke DeleteCustomOcrTemplate API
func CreateDeleteCustomOcrTemplateRequest() (request *DeleteCustomOcrTemplateRequest) {
	request = &DeleteCustomOcrTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DeleteCustomOcrTemplate", "green", "openAPI")
	return
}

// CreateDeleteCustomOcrTemplateResponse creates a response to parse from DeleteCustomOcrTemplate response
func CreateDeleteCustomOcrTemplateResponse() (response *DeleteCustomOcrTemplateResponse) {
	response = &DeleteCustomOcrTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
