package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAuditCallback invokes the green.DescribeAuditCallback API synchronously
// api document: https://help.aliyun.com/api/green/describeauditcallback.html
func (client *Client) DescribeAuditCallback(request *DescribeAuditCallbackRequest) (response *DescribeAuditCallbackResponse, err error) {
	response = CreateDescribeAuditCallbackResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAuditCallbackWithChan invokes the green.DescribeAuditCallback API asynchronously
// api document: https://help.aliyun.com/api/green/describeauditcallback.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAuditCallbackWithChan(request *DescribeAuditCallbackRequest) (<-chan *DescribeAuditCallbackResponse, <-chan error) {
	responseChan := make(chan *DescribeAuditCallbackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAuditCallback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAuditCallbackWithCallback invokes the green.DescribeAuditCallback API asynchronously
// api document: https://help.aliyun.com/api/green/describeauditcallback.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAuditCallbackWithCallback(request *DescribeAuditCallbackRequest, callback func(response *DescribeAuditCallbackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAuditCallbackResponse
		var err error
		defer close(result)
		response, err = client.DescribeAuditCallback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAuditCallbackRequest is the request struct for api DescribeAuditCallback
type DescribeAuditCallbackRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeAuditCallbackResponse is the response struct for api DescribeAuditCallback
type DescribeAuditCallbackResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Seed      string `json:"Seed" xml:"Seed"`
	Callback  string `json:"Callback" xml:"Callback"`
}

// CreateDescribeAuditCallbackRequest creates a request to invoke DescribeAuditCallback API
func CreateDescribeAuditCallbackRequest() (request *DescribeAuditCallbackRequest) {
	request = &DescribeAuditCallbackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeAuditCallback", "green", "openAPI")
	return
}

// CreateDescribeAuditCallbackResponse creates a response to parse from DescribeAuditCallback response
func CreateDescribeAuditCallbackResponse() (response *DescribeAuditCallbackResponse) {
	response = &DescribeAuditCallbackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
