package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImageResult invokes the green.ImageResult API synchronously
// api document: https://help.aliyun.com/api/green/imageresult.html
func (client *Client) ImageResult(request *ImageResultRequest) (response *ImageResultResponse, err error) {
	response = CreateImageResultResponse()
	err = client.DoAction(request, response)
	return
}

// ImageResultWithChan invokes the green.ImageResult API asynchronously
// api document: https://help.aliyun.com/api/green/imageresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ImageResultWithChan(request *ImageResultRequest) (<-chan *ImageResultResponse, <-chan error) {
	responseChan := make(chan *ImageResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImageResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImageResultWithCallback invokes the green.ImageResult API asynchronously
// api document: https://help.aliyun.com/api/green/imageresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ImageResultWithCallback(request *ImageResultRequest, callback func(response *ImageResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImageResultResponse
		var err error
		defer close(result)
		response, err = client.ImageResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImageResultRequest is the request struct for api ImageResult
type ImageResultRequest struct {
	*requests.RoaRequest
	Taskid string `position:"Path" name:"taskid"`
}

// ImageResultResponse is the response struct for api ImageResult
type ImageResultResponse struct {
	*responses.BaseResponse
}

// CreateImageResultRequest creates a request to invoke ImageResult API
func CreateImageResultRequest() (request *ImageResultRequest) {
	request = &ImageResultRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2016-12-22", "ImageResult", "/image/result/[taskid]", "green", "openAPI")
	request.Method = requests.GET
	return
}

// CreateImageResultResponse creates a response to parse from ImageResult response
func CreateImageResultResponse() (response *ImageResultResponse) {
	response = &ImageResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
