package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCustomOcrTemplate invokes the green.UpdateCustomOcrTemplate API synchronously
// api document: https://help.aliyun.com/api/green/updatecustomocrtemplate.html
func (client *Client) UpdateCustomOcrTemplate(request *UpdateCustomOcrTemplateRequest) (response *UpdateCustomOcrTemplateResponse, err error) {
	response = CreateUpdateCustomOcrTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCustomOcrTemplateWithChan invokes the green.UpdateCustomOcrTemplate API asynchronously
// api document: https://help.aliyun.com/api/green/updatecustomocrtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateCustomOcrTemplateWithChan(request *UpdateCustomOcrTemplateRequest) (<-chan *UpdateCustomOcrTemplateResponse, <-chan error) {
	responseChan := make(chan *UpdateCustomOcrTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCustomOcrTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCustomOcrTemplateWithCallback invokes the green.UpdateCustomOcrTemplate API asynchronously
// api document: https://help.aliyun.com/api/green/updatecustomocrtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateCustomOcrTemplateWithCallback(request *UpdateCustomOcrTemplateRequest, callback func(response *UpdateCustomOcrTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCustomOcrTemplateResponse
		var err error
		defer close(result)
		response, err = client.UpdateCustomOcrTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCustomOcrTemplateRequest is the request struct for api UpdateCustomOcrTemplate
type UpdateCustomOcrTemplateRequest struct {
	*requests.RpcRequest
	RecognizeArea string           `position:"Query" name:"RecognizeArea"`
	SourceIp      string           `position:"Query" name:"SourceIp"`
	ReferArea     string           `position:"Query" name:"ReferArea"`
	Name          string           `position:"Query" name:"Name"`
	Id            requests.Integer `position:"Query" name:"Id"`
}

// UpdateCustomOcrTemplateResponse is the response struct for api UpdateCustomOcrTemplate
type UpdateCustomOcrTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateCustomOcrTemplateRequest creates a request to invoke UpdateCustomOcrTemplate API
func CreateUpdateCustomOcrTemplateRequest() (request *UpdateCustomOcrTemplateRequest) {
	request = &UpdateCustomOcrTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UpdateCustomOcrTemplate", "green", "openAPI")
	return
}

// CreateUpdateCustomOcrTemplateResponse creates a response to parse from UpdateCustomOcrTemplate response
func CreateUpdateCustomOcrTemplateResponse() (response *UpdateCustomOcrTemplateResponse) {
	response = &UpdateCustomOcrTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
