package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateOssIncrementCheckSetting invokes the green.UpdateOssIncrementCheckSetting API synchronously
// api document: https://help.aliyun.com/api/green/updateossincrementchecksetting.html
func (client *Client) UpdateOssIncrementCheckSetting(request *UpdateOssIncrementCheckSettingRequest) (response *UpdateOssIncrementCheckSettingResponse, err error) {
	response = CreateUpdateOssIncrementCheckSettingResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateOssIncrementCheckSettingWithChan invokes the green.UpdateOssIncrementCheckSetting API asynchronously
// api document: https://help.aliyun.com/api/green/updateossincrementchecksetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateOssIncrementCheckSettingWithChan(request *UpdateOssIncrementCheckSettingRequest) (<-chan *UpdateOssIncrementCheckSettingResponse, <-chan error) {
	responseChan := make(chan *UpdateOssIncrementCheckSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateOssIncrementCheckSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateOssIncrementCheckSettingWithCallback invokes the green.UpdateOssIncrementCheckSetting API asynchronously
// api document: https://help.aliyun.com/api/green/updateossincrementchecksetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateOssIncrementCheckSettingWithCallback(request *UpdateOssIncrementCheckSettingRequest, callback func(response *UpdateOssIncrementCheckSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateOssIncrementCheckSettingResponse
		var err error
		defer close(result)
		response, err = client.UpdateOssIncrementCheckSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateOssIncrementCheckSettingRequest is the request struct for api UpdateOssIncrementCheckSetting
type UpdateOssIncrementCheckSettingRequest struct {
	*requests.RpcRequest
	VideoSceneList           string           `position:"Query" name:"VideoSceneList"`
	ImageSceneList           string           `position:"Query" name:"ImageSceneList"`
	VideoFrameInterval       requests.Integer `position:"Query" name:"VideoFrameInterval"`
	SourceIp                 string           `position:"Query" name:"SourceIp"`
	ImageScanLimit           string           `position:"Query" name:"ImageScanLimit"`
	VideoAutoFreezeSceneList string           `position:"Query" name:"VideoAutoFreezeSceneList"`
	Lang                     string           `position:"Query" name:"Lang"`
	ImageAutoFreeze          string           `position:"Query" name:"ImageAutoFreeze"`
	VideoMaxSize             requests.Integer `position:"Query" name:"VideoMaxSize"`
	AutoFreezeType           string           `position:"Query" name:"AutoFreezeType"`
	BucketConfigList         string           `position:"Query" name:"BucketConfigList"`
	VideoMaxFrames           requests.Integer `position:"Query" name:"VideoMaxFrames"`
}

// UpdateOssIncrementCheckSettingResponse is the response struct for api UpdateOssIncrementCheckSetting
type UpdateOssIncrementCheckSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateOssIncrementCheckSettingRequest creates a request to invoke UpdateOssIncrementCheckSetting API
func CreateUpdateOssIncrementCheckSettingRequest() (request *UpdateOssIncrementCheckSettingRequest) {
	request = &UpdateOssIncrementCheckSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UpdateOssIncrementCheckSetting", "green", "openAPI")
	return
}

// CreateUpdateOssIncrementCheckSettingResponse creates a response to parse from UpdateOssIncrementCheckSetting response
func CreateUpdateOssIncrementCheckSettingResponse() (response *UpdateOssIncrementCheckSettingResponse) {
	response = &UpdateOssIncrementCheckSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
