package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryHBaseHaDB invokes the hbase.QueryHBaseHaDB API synchronously
// api document: https://help.aliyun.com/api/hbase/queryhbasehadb.html
func (client *Client) QueryHBaseHaDB(request *QueryHBaseHaDBRequest) (response *QueryHBaseHaDBResponse, err error) {
	response = CreateQueryHBaseHaDBResponse()
	err = client.DoAction(request, response)
	return
}

// QueryHBaseHaDBWithChan invokes the hbase.QueryHBaseHaDB API asynchronously
// api document: https://help.aliyun.com/api/hbase/queryhbasehadb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryHBaseHaDBWithChan(request *QueryHBaseHaDBRequest) (<-chan *QueryHBaseHaDBResponse, <-chan error) {
	responseChan := make(chan *QueryHBaseHaDBResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryHBaseHaDB(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryHBaseHaDBWithCallback invokes the hbase.QueryHBaseHaDB API asynchronously
// api document: https://help.aliyun.com/api/hbase/queryhbasehadb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryHBaseHaDBWithCallback(request *QueryHBaseHaDBRequest, callback func(response *QueryHBaseHaDBResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryHBaseHaDBResponse
		var err error
		defer close(result)
		response, err = client.QueryHBaseHaDB(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryHBaseHaDBRequest is the request struct for api QueryHBaseHaDB
type QueryHBaseHaDBRequest struct {
	*requests.RpcRequest
	BdsId string `position:"Query" name:"BdsId"`
}

// QueryHBaseHaDBResponse is the response struct for api QueryHBaseHaDB
type QueryHBaseHaDBResponse struct {
	*responses.BaseResponse
	RequestId   string                      `json:"RequestId" xml:"RequestId"`
	TotalCount  int64                       `json:"TotalCount" xml:"TotalCount"`
	PageNumber  int                         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int                         `json:"PageSize" xml:"PageSize"`
	ClusterList ClusterListInQueryHBaseHaDB `json:"ClusterList" xml:"ClusterList"`
}

// CreateQueryHBaseHaDBRequest creates a request to invoke QueryHBaseHaDB API
func CreateQueryHBaseHaDBRequest() (request *QueryHBaseHaDBRequest) {
	request = &QueryHBaseHaDBRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "QueryHBaseHaDB", "hbase", "openAPI")
	return
}

// CreateQueryHBaseHaDBResponse creates a response to parse from QueryHBaseHaDB response
func CreateQueryHBaseHaDBResponse() (response *QueryHBaseHaDBResponse) {
	response = &QueryHBaseHaDBResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
